/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.corpus.fiche;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.corpus.fiche.FicheBlocksImpl;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.FicheItemsImpl;
import net.fichotheque.corpus.fiche.Info;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.ParaItem;
import net.fichotheque.corpus.fiche.PersonItem;
import net.fichotheque.corpus.fiche.Prop;
import net.fichotheque.corpus.fiche.Section;
import net.fichotheque.corpus.metadata.FieldKey;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.StringUtils;

public class Fiche
implements FicheAPI,
Serializable {
    private static final long serialVersionUID = 14L;
    private static final List<Prop> EMPTY_PROPLIST = Collections.emptyList();
    private static final List<Info> EMPTY_INFOLIST = Collections.emptyList();
    private static final List<Section> EMPTY_SECTIONLIST = Collections.emptyList();
    private final Map<String, Object> fieldMap = new HashMap<String, Object>();
    private ArrayList<Info> infoList;
    private ArrayList<Prop> propList;
    private ArrayList<Section> sectionList;
    private FicheItemsImpl owners = null;
    private String title = "";
    private ParaItem subtitle = null;
    private Lang lang = null;

    public void setLang(Lang lang) {
        this.lang = lang;
    }

    @Override
    public Lang getLang() {
        return this.lang;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (title == null) {
            throw new IllegalArgumentException("argument is null");
        }
        this.title = StringUtils.cleanString(title);
    }

    @Override
    public ParaItem getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(ParaItem subtitlePara) {
        this.subtitle = subtitlePara == null || subtitlePara.isEmpty() ? null : subtitlePara;
    }

    @Override
    public FicheItems getOwners() {
        return this.owners;
    }

    @Override
    public List<Prop> getPropList() {
        if (this.propList == null) {
            return EMPTY_PROPLIST;
        }
        return this.propList;
    }

    @Override
    public List<Info> getInfoList() {
        if (this.infoList == null) {
            return EMPTY_INFOLIST;
        }
        return this.infoList;
    }

    @Override
    public List<Section> getSectionList() {
        if (this.sectionList == null) {
            return EMPTY_SECTIONLIST;
        }
        return this.sectionList;
    }

    public void appendOwners(FicheItems ficheItems) {
        this.setOwners(ficheItems, true);
    }

    public void setOwners(FicheItems ficheItems) {
        this.setOwners(ficheItems, false);
    }

    private void setOwners(FicheItems ficheItems, boolean append) {
        if (ficheItems != null && ficheItems.isEmpty()) {
            ficheItems = null;
        }
        if (ficheItems == null) {
            if (!append) {
                this.owners = null;
            }
            return;
        }
        if (this.owners == null) {
            this.owners = new FicheItemsImpl();
        } else if (!append) {
            this.owners.clear();
        }
        for (FicheItem ficheItem : ficheItems) {
            if (!(ficheItem instanceof Item) && !(ficheItem instanceof PersonItem)) continue;
            this.owners.add(ficheItem);
        }
        if (this.owners.isEmpty()) {
            this.owners = null;
        }
    }

    @Override
    public Info getInfo(FieldKey fieldKey) {
        if (!fieldKey.isInfo()) {
            throw new IllegalArgumentException("fieldKey is not an Info FieldKey");
        }
        return (Info)this.getField(fieldKey);
    }

    @Override
    public Prop getProp(FieldKey fieldKey) {
        if (!fieldKey.isProp()) {
            throw new IllegalArgumentException("fieldKey is not an Prop FieldKey");
        }
        return (Prop)this.getField(fieldKey);
    }

    @Override
    public Section getSection(FieldKey fieldKey) {
        if (!fieldKey.isSection()) {
            throw new IllegalArgumentException("fieldKey is not an SectionFieldKey");
        }
        return (Section)this.getField(fieldKey);
    }

    public void appendInfo(FieldKey fieldKey, FicheItems ficheItems) {
        this.setInfo(fieldKey, ficheItems, true);
    }

    public void setInfo(FieldKey fieldKey, FicheItems ficheItems) {
        this.setInfo(fieldKey, ficheItems, false);
    }

    private void setInfo(FieldKey fieldKey, FicheItems ficheItems, boolean append) {
        InternalInfo current;
        if (!fieldKey.isInfo()) {
            throw new IllegalArgumentException("Not a Info FieldKey");
        }
        if (ficheItems != null && ficheItems.isEmpty()) {
            ficheItems = null;
        }
        if ((current = (InternalInfo)this.getField(fieldKey)) == null) {
            if (ficheItems == null) {
                return;
            }
            if (this.infoList == null) {
                this.infoList = new ArrayList();
            }
            InternalInfo info = new InternalInfo(fieldKey);
            info.addFicheItems(ficheItems);
            this.putField(fieldKey, info);
            this.infoList.add(info);
        } else if (ficheItems == null) {
            if (!append) {
                this.removeField(fieldKey);
                this.infoList.remove(current);
            }
        } else {
            if (!append) {
                current.clear();
            }
            current.addFicheItems(ficheItems);
        }
    }

    public void appendSection(FieldKey fieldKey, FicheBlocks ficheBlocks) {
        this.setSection(fieldKey, ficheBlocks, true);
    }

    public void setSection(FieldKey fieldKey, FicheBlocks ficheBlocks) {
        this.setSection(fieldKey, ficheBlocks, false);
    }

    private void setSection(FieldKey fieldKey, FicheBlocks ficheBlocks, boolean append) {
        InternalSection current;
        if (!fieldKey.isSection()) {
            throw new IllegalArgumentException("Not a Section FieldKey");
        }
        if (ficheBlocks != null && ficheBlocks.isEmpty()) {
            ficheBlocks = null;
        }
        if ((current = (InternalSection)this.getField(fieldKey)) == null) {
            if (ficheBlocks == null) {
                return;
            }
            if (this.sectionList == null) {
                this.sectionList = new ArrayList();
            }
            InternalSection section = new InternalSection(fieldKey);
            section.addAll(ficheBlocks);
            this.putField(fieldKey, section);
            this.sectionList.add(section);
        } else if (ficheBlocks == null) {
            if (!append) {
                this.removeField(fieldKey);
                this.sectionList.remove(current);
            }
        } else {
            if (!append) {
                current.clear();
            }
            current.addAll(ficheBlocks);
        }
    }

    public void setProp(FieldKey fieldKey, FicheItem ficheItem) {
        if (!fieldKey.isProp()) {
            throw new IllegalArgumentException("Not a Prop FieldKey");
        }
        InternalProp current = (InternalProp)this.getField(fieldKey);
        if (current == null) {
            if (ficheItem == null) {
                return;
            }
            if (this.propList == null) {
                this.propList = new ArrayList();
            }
            InternalProp prop = new InternalProp(fieldKey);
            prop.setFicheItem(ficheItem);
            this.putField(fieldKey, prop);
            this.propList.add(prop);
        } else if (ficheItem == null) {
            this.removeField(fieldKey);
            this.propList.remove(current);
        } else {
            current.setFicheItem(ficheItem);
        }
    }

    public void clear() {
        this.title = "";
        this.subtitle = null;
        this.owners = null;
        if (this.infoList != null) {
            this.infoList.clear();
            this.infoList = null;
        }
        if (this.propList != null) {
            this.propList.clear();
            this.propList = null;
        }
        if (this.sectionList != null) {
            this.sectionList.clear();
            this.sectionList = null;
        }
        this.clearFieldMap();
    }

    private Object getField(FieldKey fieldKey) {
        return this.fieldMap.get(fieldKey.getKeyString());
    }

    private void putField(FieldKey fieldKey, Object obj) {
        this.fieldMap.put(fieldKey.getKeyString(), obj);
    }

    private void removeField(FieldKey fieldKey) {
        this.fieldMap.remove(fieldKey.getKeyString());
    }

    private void clearFieldMap() {
        this.fieldMap.clear();
    }

    private static class InternalInfo
    extends FicheItemsImpl
    implements Info,
    Serializable {
        private final FieldKey fieldKey;

        private InternalInfo(FieldKey fieldKey) {
            this.fieldKey = fieldKey;
        }

        @Override
        public FieldKey getFieldKey() {
            return this.fieldKey;
        }
    }

    private static class InternalSection
    extends FicheBlocksImpl
    implements Section,
    Serializable {
        private final FieldKey fieldKey;

        private InternalSection(FieldKey fieldKey) {
            this.fieldKey = fieldKey;
        }

        @Override
        public FieldKey getFieldKey() {
            return this.fieldKey;
        }
    }

    private static class InternalProp
    implements Prop,
    Serializable {
        private final FieldKey fieldKey;
        private FicheItem item;

        private InternalProp(FieldKey fieldKey) {
            this.fieldKey = fieldKey;
        }

        @Override
        public FieldKey getFieldKey() {
            return this.fieldKey;
        }

        @Override
        public FicheItem getFicheItem() {
            return this.item;
        }

        private void setFicheItem(FicheItem ficheitem) {
            this.item = ficheitem;
        }
    }
}

