/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.zip;

import fr.exemole.bdfserver.api.BdfExtensionReference;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.groups.GroupDef;
import fr.exemole.bdfserver.api.managers.BalayageManager;
import fr.exemole.bdfserver.api.managers.ExtensionManager;
import fr.exemole.bdfserver.api.managers.GroupManager;
import fr.exemole.bdfserver.api.managers.PasswordManager;
import fr.exemole.bdfserver.api.managers.PermissionManager;
import fr.exemole.bdfserver.api.managers.PolicyManager;
import fr.exemole.bdfserver.api.managers.ScrutariExportManager;
import fr.exemole.bdfserver.api.managers.SelectionManager;
import fr.exemole.bdfserver.api.managers.SqlExportManager;
import fr.exemole.bdfserver.api.managers.TableExportManager;
import fr.exemole.bdfserver.api.managers.TransformationManager;
import fr.exemole.bdfserver.api.managers.UiManager;
import fr.exemole.bdfserver.api.policies.UserAllow;
import fr.exemole.bdfserver.api.roles.Role;
import fr.exemole.bdfserver.api.storage.BdfUserStorage;
import fr.exemole.bdfserver.api.storage.EditableResourceStorage;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.api.users.BdfUserPrefs;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import fr.exemole.bdfserver.tools.subsettree.TreeFilterEngine;
import fr.exemole.bdfserver.xml.configuration.LangConfigurationXMLPart;
import fr.exemole.bdfserver.xml.groups.GroupDefXMLPart;
import fr.exemole.bdfserver.xml.policies.ThesaurusPolicyXMLPart;
import fr.exemole.bdfserver.xml.policies.UserAllowXMLPart;
import fr.exemole.bdfserver.xml.roles.RedacteurListXMLPart;
import fr.exemole.bdfserver.xml.roles.RoleDefXMLPart;
import fr.exemole.bdfserver.xml.subsettree.TreeXMLPart;
import fr.exemole.bdfserver.xml.transformation.TemplateDefXMLPart;
import fr.exemole.bdfserver.xml.ui.UiComponentsXMLPart;
import fr.exemole.bdfserver.xml.users.BdfUserPrefsXMLPart;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.addenda.Document;
import net.fichotheque.addenda.Version;
import net.fichotheque.album.Album;
import net.fichotheque.album.Illustration;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.eligibility.SubsetEligibility;
import net.fichotheque.exportation.balayage.BalayageContentDescription;
import net.fichotheque.exportation.balayage.BalayageDescription;
import net.fichotheque.exportation.scrutari.ScrutariExportDef;
import net.fichotheque.exportation.sql.SqlExportDef;
import net.fichotheque.exportation.table.TableExportContentDescription;
import net.fichotheque.exportation.table.TableExportDescription;
import net.fichotheque.exportation.transformation.TemplateContentDescription;
import net.fichotheque.exportation.transformation.TemplateDescription;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.fichotheque.exportation.transformation.TransformationDescription;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.fichotheque.junction.Junction;
import net.fichotheque.junction.JunctionKey;
import net.fichotheque.junction.Junctions;
import net.fichotheque.selection.SelectionDef;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.policies.DynamicEditPolicy;
import net.fichotheque.thesaurus.policies.PolicyProvider;
import net.fichotheque.utils.EligibilityUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.xml.defs.ScrutariExportDefXMLPart;
import net.fichotheque.xml.defs.SelectionDefXMLPart;
import net.fichotheque.xml.defs.SqlExportDefXMLPart;
import net.fichotheque.xml.defs.TableExportDefXMLPart;
import net.fichotheque.xml.storage.AddendaMetadataXMLPart;
import net.fichotheque.xml.storage.AlbumMetadataXMLPart;
import net.fichotheque.xml.storage.AttributesStorageXMLPart;
import net.fichotheque.xml.storage.CorpusMetadataXMLPart;
import net.fichotheque.xml.storage.DocumentStorageXMLPart;
import net.fichotheque.xml.storage.FicheStorageXMLPart;
import net.fichotheque.xml.storage.FichothequeMetadataXMLPart;
import net.fichotheque.xml.storage.JunctionStorageXMLPart;
import net.fichotheque.xml.storage.MotcleStorageXMLPart;
import net.fichotheque.xml.storage.RedacteurStorageXMLPart;
import net.fichotheque.xml.storage.SphereListXMLPart;
import net.fichotheque.xml.storage.SphereMetadataXMLPart;
import net.fichotheque.xml.storage.ThesaurusMetadataXMLPart;
import net.fichotheque.xml.storage.ThesaurusTreeXMLPart;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.io.ResourceFolder;
import net.mapeadores.util.io.ResourceStorage;
import net.mapeadores.util.text.RelativePath;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLUtils;

public class BdfServerZip {
    private final SubsetEligibility subsetEligibility;
    private final BdfServer bdfServer;
    private final Fichotheque fichotheque;
    private final Subset[] subsetArray;
    private final String fichothequeRoot = "var/bdfdata/fichotheque/";
    private final String confRoot = "var/bdfdata/conf/";
    private final String usersRoot = "var/bdfdata/users/";
    private final String rscdataRoot = "var/rscdata/";
    private final String transformationdataRoot = "var/transformationdata/";
    private final String tableexportdataRoot = "var/tableexportdata/";
    private final String balayagedataRoot = "var/balayagedata/";
    private final String extdataRoot = "var/extdata/";
    private ZipOutputStream zipOutputStream;
    private BufferedWriter bufWriter;

    public BdfServerZip(BdfServer bdfServer, SubsetEligibility subsetEligibility) {
        this.bdfServer = bdfServer;
        this.subsetEligibility = subsetEligibility == null ? EligibilityUtils.ALL_SUBSET_ELIGIBILITY : subsetEligibility;
        this.fichotheque = bdfServer.getFichotheque();
        this.subsetArray = FichothequeUtils.getSortedSubsetArray(this.fichotheque, subsetEligibility);
    }

    public void zip(ZipOutputStream zipOutputStream) throws IOException {
        this.bufWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)zipOutputStream, "UTF-8"));
        this.zipOutputStream = zipOutputStream;
        this.zipFichotheque();
        this.zipConf();
        this.zipUsers();
        this.zipRscdata();
        this.zipTransformationdata();
        this.zipTableexportdata();
        this.zipBalayagedata();
        this.zipExtdata();
    }

    private void zipRscdata() throws IOException {
        EditableResourceStorage resourceStorage = this.bdfServer.getVarResourceStorage();
        ResourceFolder root = resourceStorage.getRoot();
        this.zipResources(resourceStorage, root, RelativePath.EMPTY);
    }

    private void zipResources(ResourceStorage resourceStorage, ResourceFolder folder, RelativePath folderPath) throws IOException {
        for (String resourceName : folder.getResourceNameList()) {
            RelativePath relativePath = folderPath.buildChild(resourceName);
            this.zipOutputStream.putNextEntry(new ZipEntry("var/rscdata/" + relativePath.toString()));
            DocStream docStream = resourceStorage.getResourceDocStream(relativePath);
            InputStream is = docStream.getInputStream();
            try {
                IOUtils.copy(is, (OutputStream)this.zipOutputStream);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        for (ResourceFolder subfolder : folder.getSubfolderList()) {
            this.zipResources(resourceStorage, subfolder, folderPath.buildChild(subfolder.getName()));
        }
    }

    private void zipTableexportdata() throws IOException {
        TableExportManager tableExportManager = this.bdfServer.getTableExportManager();
        AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(this.bufWriter);
        TableExportDefXMLPart xmlPart = new TableExportDefXMLPart(xmlWriter);
        for (TableExportDescription tableExportDescription : tableExportManager.getTableExportDescriptionList()) {
            List<TableExportContentDescription> filteredList = this.filter(tableExportDescription);
            if (filteredList.isEmpty()) continue;
            String tableExportName = tableExportDescription.getName();
            String tableExportRoot = "var/tableexportdata/" + tableExportName + "/";
            this.zipOutputStream.putNextEntry(new ZipEntry(tableExportRoot + "_def.xml"));
            xmlWriter.appendXMLDeclaration();
            xmlPart.addTableExportDef(tableExportDescription.getTableExportDef());
            this.bufWriter.flush();
            for (TableExportContentDescription tableExportContentDescription : filteredList) {
                String contentPath = tableExportContentDescription.getPath();
                this.zipOutputStream.putNextEntry(new ZipEntry(tableExportRoot + contentPath));
                this.bufWriter.write(tableExportManager.getTableExportContent(tableExportName, contentPath));
                this.bufWriter.flush();
            }
        }
    }

    private void zipBalayagedata() throws IOException {
        BalayageManager balayageManager = this.bdfServer.getBalayageManager();
        for (BalayageDescription balayageDescription : balayageManager.getBalayageDescriptionList()) {
            this.zipBalayageSubdir(balayageManager, balayageDescription, "");
            this.zipBalayageSubdir(balayageManager, balayageDescription, "extraction");
            this.zipBalayageSubdir(balayageManager, balayageDescription, "xslt");
        }
    }

    private void zipBalayageSubdir(BalayageManager balayageManager, BalayageDescription balayageDescription, String subDir) throws IOException {
        String name = balayageDescription.getName();
        for (BalayageContentDescription contentDescription : balayageDescription.getBalayageContentDescriptionList(subDir)) {
            String path = contentDescription.getPath();
            this.zipOutputStream.putNextEntry(new ZipEntry("var/balayagedata/" + name + "/" + path));
            String content = balayageManager.getBalayageContent(name, path);
            if (content == null) {
                content = "";
            }
            this.bufWriter.write(content);
            this.bufWriter.flush();
        }
    }

    private void zipTransformationdata() throws IOException {
        this.zipTransformation(TransformationKey.COMPILATION_INSTANCE);
        this.zipTransformation(TransformationKey.FORMAT_INSTANCE);
        this.zipTransformation(TransformationKey.SECTION_INSTANCE);
        this.zipTransformation(TransformationKey.STATTHESAURUS_INSTANCE);
        this.zipTransformation(TransformationKey.INVERSETHESAURUS_INSTANCE);
        this.zipTransformation(TransformationKey.MEMENTO_INSTANCE);
        for (Corpus corpus : this.fichotheque.getCorpusList()) {
            if (!this.subsetEligibility.accept(corpus)) continue;
            this.zipTransformation(new TransformationKey(corpus.getSubsetKey()));
        }
    }

    private void zipTransformation(TransformationKey transformationKey) throws IOException {
        TransformationDescription transformationDescription = this.bdfServer.getTransformationManager().getTransformationDescription(transformationKey);
        for (TemplateDescription templateDescription : transformationDescription.getSimpleTemplateDescriptionList()) {
            this.zipTemplate(templateDescription);
        }
        for (TemplateDescription templateDescription : transformationDescription.getStreamTemplateDescriptionList()) {
            this.zipTemplate(templateDescription);
        }
    }

    private void zipTemplate(TemplateDescription templateDescription) throws IOException {
        TransformationManager transformationManager = this.bdfServer.getTransformationManager();
        TemplateKey templateKey = templateDescription.getTemplateKey();
        String templateRoot = "var/transformationdata/" + templateKey.getTransformationKey() + "/" + templateKey.getName();
        templateRoot = templateKey.isStreamTemplate() ? templateRoot + "." + templateKey.getExtension() + "/" : templateRoot + "/";
        this.zipOutputStream.putNextEntry(new ZipEntry(templateRoot + "_type"));
        this.bufWriter.append(templateDescription.getType());
        this.bufWriter.flush();
        AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(this.bufWriter);
        TemplateDefXMLPart xmlPart = new TemplateDefXMLPart(xmlWriter);
        this.zipOutputStream.putNextEntry(new ZipEntry(templateRoot + "_def.xml"));
        xmlWriter.appendXMLDeclaration();
        xmlPart.addTemplateDef(templateDescription.getTemplateDef());
        this.bufWriter.flush();
        for (TemplateContentDescription templateContentDescription : templateDescription.getTemplateContentDescriptionList()) {
            this.zipOutputStream.putNextEntry(new ZipEntry(templateRoot + templateContentDescription.getPath()));
            InputStream is = transformationManager.getTemplateStorageContent(templateKey, templateContentDescription.getPath()).getInputStream();
            try {
                IOUtils.copy(is, (OutputStream)this.zipOutputStream);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
    }

    private void zipExtdata() throws IOException {
        ExtensionManager extensionManager = this.bdfServer.getExtensionManager();
        for (BdfExtensionReference bdfExtensionReference : extensionManager.getBdfExtensionReferenceList()) {
            File dir = extensionManager.getBdfExtensionStorage().getDataDirectory(bdfExtensionReference.getRegistrationName());
            if (!dir.exists()) continue;
            this.zipDir(dir, "var/extdata/");
        }
    }

    private void zipDir(File dir, String rootPath) throws IOException {
        String dirPath = rootPath + dir.getName() + "/";
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                this.zipDir(f, dirPath);
                continue;
            }
            this.zipOutputStream.putNextEntry(new ZipEntry(dirPath + f.getName()));
            try (FileInputStream is = new FileInputStream(f);){
                IOUtils.copy((InputStream)is, (OutputStream)this.zipOutputStream);
            }
        }
    }

    private void zipUsers() throws IOException {
        BdfUserStorage bdfUserStorage = this.bdfServer.getBdfUserStorage();
        for (Subset subset : this.subsetArray) {
            if (!(subset instanceof Sphere)) continue;
            Sphere sphere = (Sphere)subset;
            String sphereName = sphere.getSubsetName();
            for (Redacteur redacteur : sphere.getRedacteurList()) {
                BdfUserPrefs bdfUserPrefs = bdfUserStorage.getBdfUserPrefs(redacteur);
                int id = redacteur.getId();
                if (bdfUserPrefs == null) continue;
                this.zipOutputStream.putNextEntry(new ZipEntry("var/bdfdata/users/" + sphereName + "/r." + BdfServerUtils.getMillier(id) + "/" + id + "/prefs.xml"));
                AppendableXMLWriter prefsXmlWriter = XMLUtils.toXMLWriter(this.bufWriter);
                prefsXmlWriter.appendXMLDeclaration();
                BdfUserPrefsXMLPart bdfUserPrefsXMLPart = new BdfUserPrefsXMLPart(prefsXmlWriter);
                bdfUserPrefsXMLPart.addPrefs(bdfUserPrefs);
                this.bufWriter.flush();
            }
        }
    }

    private void zipConf() throws IOException {
        List<String> activeExtensionList;
        AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(this.bufWriter, 0);
        this.zipOutputStream.putNextEntry(new ZipEntry("var/bdfdata/conf/lang-configuration.xml"));
        LangConfigurationXMLPart langConfigurationXMLPart = new LangConfigurationXMLPart(xmlWriter);
        xmlWriter.appendXMLDeclaration();
        langConfigurationXMLPart.addLangConfiguration(this.bdfServer.getLangConfiguration());
        this.bufWriter.flush();
        PasswordManager passwordManager = this.bdfServer.getPasswordManager();
        String[] passwordArray = passwordManager.toPasswordArray();
        if (passwordArray.length > 0) {
            this.zipOutputStream.putNextEntry(new ZipEntry("var/bdfdata/conf/passwd"));
            StorageUtils.writePasswordArray(this.bufWriter, passwordArray);
            this.bufWriter.flush();
        }
        if (!(activeExtensionList = BdfServerUtils.toActiveExtensionList(this.bdfServer.getExtensionManager().getBdfExtensionReferenceList())).isEmpty()) {
            this.zipOutputStream.putNextEntry(new ZipEntry("var/bdfdata/conf/extensions"));
            StorageUtils.writeExtensionList(this.bufWriter, activeExtensionList);
            this.bufWriter.flush();
        }
        this.zipGroups();
        this.zipPolicies();
        this.zipRedacteurLists();
        this.zipRoles();
        this.zipSelection();
        this.zipSqlExport();
        this.zipScrutariExport();
        this.zipSubsetTree((short)1, xmlWriter);
        this.zipSubsetTree((short)2, xmlWriter);
        this.zipSubsetTree((short)3, xmlWriter);
        this.zipSubsetTree((short)5, xmlWriter);
        this.zipSubsetTree((short)4, xmlWriter);
        UiManager uiManager = this.bdfServer.getUiManager();
        UiComponentsXMLPart uiComponentsXMLPart = new UiComponentsXMLPart(xmlWriter);
        for (Subset subset : this.subsetArray) {
            if (!(subset instanceof Corpus)) continue;
            Corpus corpus = (Corpus)subset;
            UiComponents uiComponents = uiManager.getMainUiComponents(corpus);
            this.zipOutputStream.putNextEntry(new ZipEntry("var/bdfdata/conf/ui/corpus/" + corpus.getSubsetName() + "/_main.xml"));
            xmlWriter.appendXMLDeclaration();
            uiComponentsXMLPart.appendUiComponents(uiComponents);
            this.bufWriter.flush();
        }
    }

    private void zipGroups() throws IOException {
        GroupManager groupManager = this.bdfServer.getGroupManager();
        List<GroupDef> groupDefList = groupManager.getGroupDefList();
        if (!groupDefList.isEmpty()) {
            AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(this.bufWriter);
            GroupDefXMLPart groupDefXMLPart = new GroupDefXMLPart(xmlWriter);
            for (GroupDef groupDef : groupDefList) {
                this.zipOutputStream.putNextEntry(new ZipEntry("var/bdfdata/conf/groups/" + groupDef.getName() + ".xml"));
                xmlWriter.appendXMLDeclaration();
                groupDefXMLPart.addGroupDef(groupDef);
                this.bufWriter.flush();
            }
        }
    }

    private void zipPolicies() throws IOException {
        PolicyManager policyManager = this.bdfServer.getPolicyManager();
        AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(this.bufWriter);
        UserAllowXMLPart userAllowXMLPart = new UserAllowXMLPart(xmlWriter);
        UserAllow userAllow = policyManager.getUserAllow();
        this.zipOutputStream.putNextEntry(new ZipEntry("var/bdfdata/conf/policies/user-allow.xml"));
        xmlWriter.appendXMLDeclaration();
        userAllowXMLPart.addUserAllow(userAllow);
        this.bufWriter.flush();
        PolicyProvider policyProvider = policyManager.getPolicyProvider();
        ThesaurusPolicyXMLPart thesaurusPolicyXMLPart = new ThesaurusPolicyXMLPart(xmlWriter);
        for (Subset subset : this.subsetArray) {
            DynamicEditPolicy dynamicEditPolicy;
            if (!(subset instanceof Thesaurus) || (dynamicEditPolicy = policyProvider.getDynamicEditPolicy((Thesaurus)subset)).equals("none")) continue;
            SubsetKey subsetKey = subset.getSubsetKey();
            this.zipOutputStream.putNextEntry(new ZipEntry("var/bdfdata/conf/policies/" + subsetKey + ".xml"));
            xmlWriter.appendXMLDeclaration();
            thesaurusPolicyXMLPart.addThesaurusPolicy(subsetKey, dynamicEditPolicy);
            this.bufWriter.flush();
        }
    }

    private void zipRedacteurLists() throws IOException {
        PermissionManager permissionManager = this.bdfServer.getPermissionManager();
        AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(this.bufWriter);
        RedacteurListXMLPart redacteurListXMLPart = new RedacteurListXMLPart(xmlWriter);
        List<Redacteur> redacteurList = permissionManager.getAdminRedacteurList();
        this.zipOutputStream.putNextEntry(new ZipEntry("var/bdfdata/conf/redacteurlists/admin.xml"));
        xmlWriter.appendXMLDeclaration();
        redacteurListXMLPart.addRedacteurList(redacteurList);
        this.bufWriter.flush();
        List<Role> roleList = permissionManager.getRoleList();
        for (Role role : roleList) {
            redacteurList = permissionManager.getRedacteurList(role);
            this.zipOutputStream.putNextEntry(new ZipEntry("var/bdfdata/conf/redacteurlists/role_" + role.getName() + ".xml"));
            xmlWriter.appendXMLDeclaration();
            redacteurListXMLPart.addRedacteurList(redacteurList);
            this.bufWriter.flush();
        }
    }

    private void zipRoles() throws IOException {
        List<Role> roleList = this.bdfServer.getPermissionManager().getRoleList();
        if (!roleList.isEmpty()) {
            AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(this.bufWriter);
            RoleDefXMLPart xmlPart = new RoleDefXMLPart(xmlWriter);
            for (Role role : roleList) {
                this.zipOutputStream.putNextEntry(new ZipEntry("var/bdfdata/conf/roles/" + role.getName() + ".xml"));
                xmlWriter.appendXMLDeclaration();
                xmlPart.addRoleDef(role, this.subsetEligibility);
                this.bufWriter.flush();
            }
        }
    }

    private void zipSelection() throws IOException {
        SelectionManager selectionManager = this.bdfServer.getSelectionManager();
        List<SelectionDef> selectionDefList = selectionManager.getSelectionDefList();
        if (!selectionDefList.isEmpty()) {
            AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(this.bufWriter);
            SelectionDefXMLPart xmlPart = new SelectionDefXMLPart(xmlWriter);
            for (SelectionDef selectionDef : selectionDefList) {
                this.zipOutputStream.putNextEntry(new ZipEntry("var/bdfdata/conf/selection/" + selectionDef.getName() + ".xml"));
                xmlWriter.appendXMLDeclaration();
                xmlPart.addSelectionDef(selectionDef);
                this.bufWriter.flush();
            }
        }
    }

    private void zipSqlExport() throws IOException {
        SqlExportManager sqlExportManager = this.bdfServer.getSqlExportManager();
        List<SqlExportDef> sqlExportDefList = sqlExportManager.getSqlExportDefList();
        if (!sqlExportDefList.isEmpty()) {
            AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(this.bufWriter);
            SqlExportDefXMLPart xmlPart = new SqlExportDefXMLPart(xmlWriter);
            for (SqlExportDef sqlExportDef : sqlExportDefList) {
                this.zipOutputStream.putNextEntry(new ZipEntry("var/bdfdata/conf/sqlexport/" + sqlExportDef.getName() + ".xml"));
                xmlWriter.appendXMLDeclaration();
                xmlPart.addSqlExportDef(sqlExportDef);
                this.bufWriter.flush();
            }
        }
    }

    private void zipScrutariExport() throws IOException {
        ScrutariExportManager scrutariExportManager = this.bdfServer.getScrutariExportManager();
        List<ScrutariExportDef> scrutariExportDefList = scrutariExportManager.getScrutariExportDefList();
        if (!scrutariExportDefList.isEmpty()) {
            AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(this.bufWriter);
            ScrutariExportDefXMLPart xmlPart = new ScrutariExportDefXMLPart(xmlWriter);
            for (ScrutariExportDef scrutariExportDef : scrutariExportDefList) {
                this.zipOutputStream.putNextEntry(new ZipEntry("var/bdfdata/conf/scrutariexport/" + scrutariExportDef.getName() + ".xml"));
                xmlWriter.appendXMLDeclaration();
                xmlPart.addScrutariExportDef(scrutariExportDef);
                this.bufWriter.flush();
            }
        }
    }

    private void zipSubsetTree(short category, AppendableXMLWriter xmlWriter) throws IOException {
        SubsetTree subsetTree = this.bdfServer.getTreeManager().getSubsetTree(category);
        subsetTree = TreeFilterEngine.selection(this.subsetEligibility, subsetTree);
        TreeXMLPart treeXMLPart = new TreeXMLPart(xmlWriter);
        this.zipOutputStream.putNextEntry(new ZipEntry("var/bdfdata/conf/trees/" + SubsetKey.categoryToString(category) + ".xml"));
        xmlWriter.appendXMLDeclaration();
        treeXMLPart.addTree(subsetTree);
        this.bufWriter.flush();
    }

    private void zipFichotheque() throws IOException {
        this.zipOutputStream.putNextEntry(new ZipEntry("var/bdfdata/fichotheque/metadata.xml"));
        AppendableXMLWriter fichothequeMetadataXmlWriter = XMLUtils.toXMLWriter(this.bufWriter);
        fichothequeMetadataXmlWriter.appendXMLDeclaration();
        FichothequeMetadataXMLPart fichothequeMetadataXMLPart = new FichothequeMetadataXMLPart(fichothequeMetadataXmlWriter);
        fichothequeMetadataXMLPart.appendFichothequeMetadata(this.fichotheque.getFichothequeMetadata());
        this.bufWriter.flush();
        for (Subset subset : this.subsetArray) {
            if (subset instanceof Corpus) {
                this.zipCorpus((Corpus)subset);
                continue;
            }
            if (subset instanceof Thesaurus) {
                this.zipThesaurus((Thesaurus)subset);
                continue;
            }
            if (subset instanceof Sphere) {
                this.zipSphere((Sphere)subset);
                continue;
            }
            if (subset instanceof Addenda) {
                this.zipAddenda((Addenda)subset);
                continue;
            }
            if (!(subset instanceof Album)) continue;
            this.zipAlbum((Album)subset);
        }
        int subsetLength = this.subsetArray.length;
        for (int i = 0; i < subsetLength; ++i) {
            Subset subset = this.subsetArray[i];
            Predicate<SubsetItem> predicate = this.subsetEligibility.getPredicate(subset);
            for (SubsetItem subsetItem : subset.getSubsetItemList()) {
                if (!this.testSubsetItem(subsetItem, predicate)) continue;
                Junctions autoJunctions = this.fichotheque.getJunctions(subsetItem, subset);
                for (Junctions.Entry entry : autoJunctions.getEntryList()) {
                    SubsetItem otherSubsetItem = entry.getSubsetItem();
                    if (!this.testSubsetItem(otherSubsetItem, predicate) || otherSubsetItem.getId() <= subsetItem.getId()) continue;
                    this.zipJunction(entry.getJunction());
                }
                for (int k = i + 1; k < subsetLength; ++k) {
                    Subset otherSubset = this.subsetArray[k];
                    Predicate<SubsetItem> otherPredicate = this.subsetEligibility.getPredicate(otherSubset);
                    Junctions junctions = this.fichotheque.getJunctions(subsetItem, otherSubset);
                    for (Junctions.Entry entry : junctions.getEntryList()) {
                        SubsetItem otherSubsetItem = entry.getSubsetItem();
                        if (!this.testSubsetItem(otherSubsetItem, otherPredicate)) continue;
                        this.zipJunction(entry.getJunction());
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void zipCorpus(Corpus corpus) throws IOException {
        Predicate<SubsetItem> predicate = this.subsetEligibility.getPredicate(corpus);
        String corpusName = corpus.getSubsetName();
        String entryPath = "var/bdfdata/fichotheque/corpus/";
        Subset masterSubset = corpus.getMasterSubset();
        if (masterSubset != null) {
            String masterSubsetName = masterSubset.getSubsetName();
            if (masterSubset instanceof Corpus) {
                entryPath = entryPath + "_mc_" + masterSubsetName + "_" + corpusName + ".xml";
            } else {
                if (!(masterSubset instanceof Thesaurus)) throw new UnsupportedOperationException("Unkwnown Master Subset implementation : " + masterSubset.getClass().getName());
                entryPath = entryPath + "_mt_" + masterSubsetName + "_" + corpusName + ".xml";
            }
        } else {
            entryPath = entryPath + corpusName + ".xml";
        }
        this.zipOutputStream.putNextEntry(new ZipEntry(entryPath));
        AppendableXMLWriter metadataXmlWriter = XMLUtils.toXMLWriter(this.bufWriter);
        metadataXmlWriter.appendXMLDeclaration();
        CorpusMetadataXMLPart corpusMetadataXMLPart = new CorpusMetadataXMLPart(metadataXmlWriter);
        corpusMetadataXMLPart.appendCorpusMetadata(corpus.getCorpusMetadata());
        this.bufWriter.flush();
        for (FicheMeta ficheMeta : corpus.getFicheMetaList()) {
            if (!this.testSubsetItem(ficheMeta, predicate)) continue;
            int id = ficheMeta.getId();
            FicheAPI fiche = corpus.getFicheAPI(ficheMeta, true);
            String ficheracine = "var/bdfdata/fichotheque/corpus/" + corpusName + "/f." + BdfServerUtils.getMillier(id) + "/" + id + "/";
            this.zipOutputStream.putNextEntry(new ZipEntry(ficheracine + "fiche.xml"));
            AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(this.bufWriter);
            xmlWriter.appendXMLDeclaration();
            FicheStorageXMLPart ficheStorageXMLPart = new FicheStorageXMLPart(xmlWriter);
            ficheStorageXMLPart.appendFiche(fiche);
            this.bufWriter.flush();
            if (!ficheMeta.getAttributes().isEmpty()) {
                this.zipOutputStream.putNextEntry(new ZipEntry(ficheracine + "attributes.xml"));
                AppendableXMLWriter attributesXmlWriter = XMLUtils.toXMLWriter(this.bufWriter);
                attributesXmlWriter.appendXMLDeclaration();
                AttributesStorageXMLPart attributesStorageXMLPart = new AttributesStorageXMLPart(xmlWriter);
                attributesStorageXMLPart.appendAttributes(ficheMeta.getAttributes());
                this.bufWriter.flush();
            }
            this.zipOutputStream.putNextEntry(new ZipEntry(ficheracine + "chrono.txt"));
            StorageUtils.writeChrono(this.bufWriter, ficheMeta);
            this.bufWriter.flush();
        }
    }

    private void zipThesaurus(Thesaurus thesaurus) throws IOException {
        Predicate<SubsetItem> predicate = this.subsetEligibility.getPredicate(thesaurus);
        String thesaurusName = thesaurus.getSubsetName();
        this.zipOutputStream.putNextEntry(new ZipEntry("var/bdfdata/fichotheque/thesaurus/" + thesaurusName + ".xml"));
        AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(this.bufWriter);
        xmlWriter.appendXMLDeclaration();
        ThesaurusMetadataXMLPart thesaurusMetadataXMLPart = new ThesaurusMetadataXMLPart(xmlWriter);
        thesaurusMetadataXMLPart.appendThesaurusMetadata(thesaurus.getThesaurusMetadata());
        this.bufWriter.flush();
        this.zipOutputStream.putNextEntry(new ZipEntry("var/bdfdata/fichotheque/thesaurus/" + thesaurusName + "/tree.xml"));
        AppendableXMLWriter treeXmlWriter = XMLUtils.toXMLWriter(this.bufWriter);
        treeXmlWriter.appendXMLDeclaration();
        ThesaurusTreeXMLPart thesaurusTreeXMLPart = new ThesaurusTreeXMLPart(treeXmlWriter);
        thesaurusTreeXMLPart.appendThesaurus(thesaurus, predicate);
        this.bufWriter.flush();
        this.zipMotcleList(thesaurusName, thesaurus.getFirstLevelList(), predicate);
    }

    private void zipSphere(Sphere sphere) throws IOException {
        Predicate<SubsetItem> predicate = this.subsetEligibility.getPredicate(sphere);
        String sphereName = sphere.getSubsetName();
        this.zipOutputStream.putNextEntry(new ZipEntry("var/bdfdata/fichotheque/sphere/" + sphereName + ".xml"));
        AppendableXMLWriter metadataXmlWriter = XMLUtils.toXMLWriter(this.bufWriter);
        metadataXmlWriter.appendXMLDeclaration();
        SphereMetadataXMLPart sphereMetadataXMLPart = new SphereMetadataXMLPart(metadataXmlWriter);
        sphereMetadataXMLPart.appendSphereMetadata(sphere.getSphereMetadata());
        this.bufWriter.flush();
        this.zipOutputStream.putNextEntry(new ZipEntry("var/bdfdata/fichotheque/sphere/" + sphereName + "/list.xml"));
        AppendableXMLWriter listXmlWriter = XMLUtils.toXMLWriter(this.bufWriter);
        listXmlWriter.appendXMLDeclaration();
        SphereListXMLPart sphereListXMLPart = new SphereListXMLPart(listXmlWriter);
        sphereListXMLPart.appendSphereList(sphere, predicate);
        this.bufWriter.flush();
        for (Redacteur redacteur : sphere.getRedacteurList()) {
            if (!this.testSubsetItem(redacteur, predicate)) continue;
            int id = redacteur.getId();
            this.zipOutputStream.putNextEntry(new ZipEntry("var/bdfdata/fichotheque/sphere/" + sphereName + "/r." + BdfServerUtils.getMillier(id) + "/" + id + ".xml"));
            AppendableXMLWriter redacteurXmlWriter = XMLUtils.toXMLWriter(this.bufWriter);
            redacteurXmlWriter.appendXMLDeclaration();
            RedacteurStorageXMLPart redacteurStorageXMLPart = new RedacteurStorageXMLPart(redacteurXmlWriter);
            redacteurStorageXMLPart.appendRedacteur(redacteur);
            this.bufWriter.flush();
        }
    }

    private void zipAddenda(Addenda addenda) throws IOException {
        Predicate<SubsetItem> predicate = this.subsetEligibility.getPredicate(addenda);
        String addendaName = addenda.getSubsetName();
        this.zipOutputStream.putNextEntry(new ZipEntry("var/bdfdata/fichotheque/addenda/" + addendaName + ".xml"));
        AppendableXMLWriter metadataXmlWriter = XMLUtils.toXMLWriter(this.bufWriter);
        metadataXmlWriter.appendXMLDeclaration();
        AddendaMetadataXMLPart addendaMetadataXMLPart = new AddendaMetadataXMLPart(metadataXmlWriter);
        addendaMetadataXMLPart.appendAddendaMetadata(addenda.getAddendaMetadata());
        this.bufWriter.flush();
        for (Document document : addenda.getDocumentList()) {
            if (!this.testSubsetItem(document, predicate)) continue;
            int id = document.getId();
            String documentRoot = "var/bdfdata/fichotheque/addenda/" + addendaName + "/d." + BdfServerUtils.getMillier(id) + "/" + id + "/";
            for (Version version : document.getVersionList()) {
                this.zipOutputStream.putNextEntry(new ZipEntry(documentRoot + "doc." + version.getExtension()));
                InputStream is = version.getInputStream();
                try {
                    IOUtils.copy(is, (OutputStream)this.zipOutputStream);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            this.zipOutputStream.putNextEntry(new ZipEntry(documentRoot + "document.xml"));
            AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(this.bufWriter);
            xmlWriter.appendXMLDeclaration();
            DocumentStorageXMLPart documentStorageXMLPart = new DocumentStorageXMLPart(xmlWriter);
            documentStorageXMLPart.appendDocument(document);
            this.bufWriter.flush();
        }
    }

    private void zipAlbum(Album album) throws IOException {
        Predicate<SubsetItem> predicate = this.subsetEligibility.getPredicate(album);
        String subsetName = album.getSubsetName();
        this.zipOutputStream.putNextEntry(new ZipEntry("var/bdfdata/fichotheque/album/" + subsetName + ".xml"));
        AppendableXMLWriter metadataXmlWriter = XMLUtils.toXMLWriter(this.bufWriter);
        metadataXmlWriter.appendXMLDeclaration();
        AlbumMetadataXMLPart albumMetadataXMLPart = new AlbumMetadataXMLPart(metadataXmlWriter);
        albumMetadataXMLPart.appendAlbumMetadata(album.getAlbumMetadata());
        this.bufWriter.flush();
        for (Illustration illustration : album.getIllustrationList()) {
            if (!this.testSubsetItem(illustration, predicate)) continue;
            int id = illustration.getId();
            String illustrationracine = "var/bdfdata/fichotheque/album/" + subsetName + "/i." + BdfServerUtils.getMillier(id) + "/" + id + "/";
            this.zipOutputStream.putNextEntry(new ZipEntry(illustrationracine + "img." + illustration.getFormatType()));
            InputStream is = illustration.getInputStream("_original");
            try {
                IOUtils.copy(is, (OutputStream)this.zipOutputStream);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
    }

    private void zipMotcleList(String thesaurusName, List<Motcle> motcleList, Predicate<SubsetItem> predicate) throws IOException {
        for (Motcle motcle : motcleList) {
            int id = motcle.getId();
            if (predicate != null && !predicate.test(motcle)) continue;
            String motcleEntryPath = "var/bdfdata/fichotheque/thesaurus/" + thesaurusName + "/m." + BdfServerUtils.getMillier(id) + "/" + id + ".xml";
            this.zipOutputStream.putNextEntry(new ZipEntry(motcleEntryPath));
            AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(this.bufWriter);
            xmlWriter.appendXMLDeclaration();
            MotcleStorageXMLPart motcleStorageXMLPart = new MotcleStorageXMLPart(xmlWriter);
            motcleStorageXMLPart.appendMotcle(motcle);
            this.bufWriter.flush();
            this.zipMotcleList(thesaurusName, motcle.getChildList(), predicate);
        }
    }

    private void zipJunction(Junction junction) throws IOException {
        JunctionKey junctionKey = junction.getJunctionKey();
        SubsetKey subsetKey1 = junctionKey.getSubsetKey1();
        SubsetKey subsetKey2 = junctionKey.getSubsetKey2();
        int id1 = junctionKey.getId1();
        int id2 = junctionKey.getId2();
        StringBuilder buf = new StringBuilder();
        buf.append("var/bdfdata/fichotheque/");
        buf.append(subsetKey1.getCategoryString());
        buf.append("_");
        buf.append(subsetKey2.getCategoryString());
        buf.append("/");
        buf.append(subsetKey1.getSubsetName());
        buf.append("_");
        buf.append(subsetKey2.getSubsetName());
        buf.append("/c.");
        buf.append(BdfServerUtils.getMillier(id1));
        buf.append("_");
        buf.append(BdfServerUtils.getMillier(id2));
        buf.append("/");
        buf.append(id1);
        buf.append("_");
        buf.append(id2);
        buf.append(".xml");
        this.zipOutputStream.putNextEntry(new ZipEntry(buf.toString()));
        AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(this.bufWriter);
        xmlWriter.appendXMLDeclaration();
        JunctionStorageXMLPart junctionStorageXMLPart = new JunctionStorageXMLPart(xmlWriter);
        junctionStorageXMLPart.appendJunction(junction);
        this.bufWriter.flush();
    }

    private boolean testSubsetItem(SubsetItem subsetItem, Predicate<SubsetItem> predicate) {
        if (subsetItem == null) {
            return false;
        }
        return predicate.test(subsetItem);
    }

    private List<TableExportContentDescription> filter(TableExportDescription tableExportDescription) {
        ArrayList<TableExportContentDescription> result = new ArrayList<TableExportContentDescription>();
        for (TableExportContentDescription tableExportContentDescription : tableExportDescription.getTableExportContentDescriptionList()) {
            SubsetKey subsetKey = tableExportContentDescription.getSubsetKey();
            if (subsetKey != null && !this.subsetEligibility.accept(subsetKey)) continue;
            result.add(tableExportContentDescription);
        }
        return result;
    }
}

