/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.uml;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.api.storage.StorageRoot;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import net.mapeadores.util.io.FileUtils;
import net.mapeadores.util.text.RelativePath;
import net.mapeadores.util.uml.PumlUtils;

public class DiagramCache {
    private final BdfServer bdfServer;
    private final StorageRoot cacheStorage;

    public DiagramCache(BdfServer bdfServer) {
        this.bdfServer = bdfServer;
        this.cacheStorage = bdfServer.getCacheStorage();
    }

    public File getFile(String name, String pumlEncoded, String extension) {
        try {
            CacheEntry cacheEntry = new CacheEntry(name, pumlEncoded);
            return cacheEntry.getFile(extension);
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
    }

    private class CacheEntry {
        private final String name;
        private final File entryDir;
        private final File codeFile;
        private final String pumlEncoded;
        private final boolean useCache;

        private CacheEntry(String name, String pumlEncoded) throws IOException {
            this.name = name;
            this.entryDir = DiagramCache.this.cacheStorage.getFile(RelativePath.build("diagrams/" + name));
            if (!this.entryDir.exists()) {
                this.entryDir.mkdirs();
            }
            this.codeFile = new File(this.entryDir, "code");
            this.pumlEncoded = pumlEncoded;
            this.useCache = this.checkUseCache();
        }

        public File getFile(String extension) throws IOException {
            File cacheFile = new File(this.entryDir, "diagram." + extension);
            if (!this.useCache || !cacheFile.exists()) {
                try (FileOutputStream os = new FileOutputStream(cacheFile);){
                    PumlUtils.download(this.pumlEncoded, extension, os);
                }
            }
            return cacheFile;
        }

        private boolean checkUseCache() throws IOException {
            if (!this.codeFile.exists()) {
                this.saveCode();
                return false;
            }
            String currentCode = FileUtils.readFileToString(this.codeFile, "UTF-8");
            if (currentCode.equals(this.pumlEncoded)) {
                return true;
            }
            this.saveCode();
            return false;
        }

        private void saveCode() throws IOException {
            FileUtils.cleanDirectory(this.entryDir);
            FileUtils.writeStringToFile(this.codeFile, this.pumlEncoded, "UTF-8");
        }
    }
}

