/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.storage;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.io.ResourceStorages;
import net.mapeadores.util.jslib.JsAnalyser;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.text.RelativePath;

public class ResourceJsAnalyser
implements JsAnalyser {
    private static final Set<String> EMPTY_SET = Collections.emptySet();
    private final ResourceStorages resourceStorages;
    private final Map<RelativePath, Set<String>> messageKeyMap = new HashMap<RelativePath, Set<String>>();

    public ResourceJsAnalyser(ResourceStorages resourceStorages) {
        this.resourceStorages = resourceStorages;
    }

    @Override
    public Set<String> getJsMessageKeySet(RelativePath relativePath) {
        Set<String> set = this.messageKeyMap.get(relativePath);
        if (set == null) {
            set = this.buildSet(relativePath);
        }
        return set;
    }

    @Override
    public synchronized void clearCache() {
        this.messageKeyMap.clear();
    }

    private synchronized Set<String> buildSet(RelativePath relativePath) {
        Set<String> set;
        block10: {
            set = this.messageKeyMap.get(relativePath);
            if (set != null) {
                return set;
            }
            DocStream docStream = this.resourceStorages.getResourceDocStream(relativePath);
            if (docStream != null) {
                try (InputStream is = docStream.getInputStream();){
                    set = Collections.unmodifiableSet(LocalisationUtils.scanMessageKeys(is, docStream.getCharset()));
                    break block10;
                }
                catch (IOException ioe) {
                    throw new NestedIOException(ioe);
                }
            }
            set = EMPTY_SET;
        }
        this.messageKeyMap.put(relativePath, set);
        return set;
    }
}

