/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.exportation.transformation.defaulttemplates;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.ui.CommentUi;
import fr.exemole.bdfserver.api.ui.DataUi;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.SpecialIncludeUi;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.exportation.transformation.defaulttemplates.AbstractFicheXsltWriter;
import fr.exemole.bdfserver.tools.ui.UiUtils;
import java.io.IOException;
import java.util.List;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;

public class SimpleFicheXsltWriter
extends AbstractFicheXsltWriter {
    public SimpleFicheXsltWriter(BdfServer bdfServer, int extractVersion) {
        super(bdfServer, extractVersion);
    }

    public void add(Corpus corpus, boolean withCorpusCondition) throws IOException {
        if (corpus == null) {
            this.openMatchXslTemplate("fiche", null);
            this.closeXslTemplate();
            return;
        }
        UiComponents uiComponents = this.uiManager.getMainUiComponents(corpus);
        List<Corpus> includedCorpusList = BdfServerUtils.getIncludeSatelliteList(corpus);
        List<UiComponent> uiComponentList = uiComponents.getUiComponentList();
        if (!includedCorpusList.isEmpty()) {
            uiComponentList = UiUtils.filter(uiComponentList, UiUtils.MAIN_COMPONENTPREDICATE);
        }
        if (withCorpusCondition) {
            this.openMatchXslTemplate("fiche[@corpus='" + corpus.getSubsetName() + "']", null);
        } else {
            this.openMatchXslTemplate("fiche", null);
        }
        this.appendMainUiComponents(corpus, uiComponents, uiComponentList, includedCorpusList);
        this.closeXslTemplate();
        this.addSeparator();
        for (Corpus satellite : includedCorpusList) {
            UiComponents satelliteUiComponents = this.uiManager.getMainUiComponents(satellite);
            List<UiComponent> satelliteList = UiUtils.filter(satelliteUiComponents.getUiComponentList(), UiUtils.SATELLITE_COMPONENTPREDICATE);
            this.openMatchXslTemplate("fiche[@corpus='" + satellite.getSubsetName() + "']", "_satellite");
            this.addSatelliteUiComponents(satellite, satelliteList);
            this.closeXslTemplate();
            this.addSeparator();
        }
    }

    private void appendMainUiComponents(Corpus corpus, UiComponents uiComponents, List<UiComponent> filteredList, List<Corpus> includedCorpusList) throws IOException {
        CorpusMetadata corpusMetadata = corpus.getCorpusMetadata();
        String subsetName = corpus.getSubsetName();
        this.addXslVariable("label", "$LABELS[@corpus='" + subsetName + "']/label", false);
        this.addSeparator();
        this.openTag("article");
        this.addSeparator();
        this.startOpenTag("header");
        this.addAttribute("class", "fiche-Header");
        this.endOpenTag();
        this.apply(".", "component-Header");
        if (uiComponents.contains(FieldKey.SUBTITLE)) {
            this.apply(this.tagNames.getSubtitleTagName(), "component-Header");
        }
        this.closeTag("header");
        this.addSeparator();
        this.appendUiComponentList(filteredList, corpusMetadata);
        for (Corpus satellite : includedCorpusList) {
            this.addXslApplyTemplates("fiche[@corpus='" + satellite.getSubsetName() + "']", "_satellite", true);
            this.addSeparator();
        }
        this.appendChrono();
        this.closeTag("article");
        this.addSeparator();
    }

    private void addSatelliteUiComponents(Corpus satellite, List<UiComponent> satelliteList) throws IOException {
        CorpusMetadata corpusMetadata = satellite.getCorpusMetadata();
        String subsetName = satellite.getSubsetName();
        this.addXslVariable("label", "$LABELS/satellite[@corpus='" + subsetName + "']/label", false);
        this.addSeparator();
        this.startOpenTag("section");
        this.addAttribute("class", "fiche-satellite-Block");
        this.addAttribute("data-bdf-milestone", "satellite");
        this.addAttribute("data-bdf-satellite", subsetName);
        this.endOpenTag();
        this.startOpenTag("h1");
        this.addAttribute("class", "fiche-satellite-Title");
        this.endOpenTag();
        this.addXslValueOf("$LABELS/satellite[@corpus='" + subsetName + "']/@title");
        this.addXslApplyTemplates(this.tagNames.getSubtitleTagName());
        this.closeTag("h1", false);
        this.appendUiComponentList(satelliteList, corpusMetadata);
        this.closeTag("section");
    }

    private void appendUiComponentList(List<UiComponent> uiComponentList, CorpusMetadata corpusMetadata) throws IOException {
        for (UiComponent uiComponent : uiComponentList) {
            if (uiComponent instanceof FieldUi) {
                this.appendFieldUi((FieldUi)uiComponent, corpusMetadata);
                continue;
            }
            if (uiComponent instanceof SpecialIncludeUi) {
                this.appendSpecialIncludeUi((SpecialIncludeUi)uiComponent);
                continue;
            }
            if (uiComponent instanceof SubsetIncludeUi) {
                this.appendSubsetIncludeUi((SubsetIncludeUi)uiComponent);
                continue;
            }
            if (uiComponent instanceof CommentUi) {
                this.appendCommentUi((CommentUi)uiComponent);
                continue;
            }
            if (!(uiComponent instanceof DataUi)) continue;
            this.appendDataUi((DataUi)uiComponent);
        }
    }

    private void appendSpecialIncludeUi(SpecialIncludeUi includeUi) throws IOException {
        switch (includeUi.getName()) {
            case "liage": {
                this.apply(this.tagNames.getSubsetTagName((short)1) + "[@name='" + "liage" + "']", "component-Listitem", includeUi.getName());
                break;
            }
            case "parentage": {
                this.apply(".", "component-Parentage", includeUi.getName());
            }
        }
    }
}

