/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.exportation.transformation.compilers;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.configuration.PathConfiguration;
import fr.exemole.bdfserver.api.exportation.transformation.StreamTemplateFactory;
import fr.exemole.bdfserver.api.storage.TemplateStorage;
import fr.exemole.bdfserver.tools.BdfURI;
import fr.exemole.bdfserver.tools.exportation.transformation.BdfPictureHandler;
import fr.exemole.bdfserver.tools.exportation.transformation.XsltStreamTemplateFactory;
import fr.exemole.bdfserver.tools.exportation.transformation.compilers.CompilationException;
import fr.exemole.bdfserver.tools.exportation.transformation.compilers.StreamTemplateCompiler;
import fr.exemole.bdfserver.tools.exportation.transformation.compilers.TemplateCompilerUtils;
import fr.exemole.bdfserver.tools.exportation.transformation.defaulttemplates.DefaultTemplateUtils;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.TransformerException;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.fichotheque.extraction.def.ExtractionDef;
import net.fichotheque.tools.exportation.transformation.TemplateContentDescriptionBuilder;
import net.mapeadores.opendocument.css.output.StylesConversionEngine;
import net.mapeadores.opendocument.elements.ElementMaps;
import net.mapeadores.opendocument.transform.ODStreamTransformerBuilder;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.io.StreamTransformer;
import net.mapeadores.util.io.StreamTransformerErrorHandler;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.xml.XMLUtils;

public class XsltOdStreamTemplateCompiler
extends StreamTemplateCompiler {
    private static final String CCS_MARKUP = "<!-- CSS -->";
    private static final String CONTENT_XSL = "content.xsl";
    private static final String EXTRACTION_PATH = "extraction.xml";
    private static final String STYLES_CSS = "styles.css";
    private static final String STYLES_XML = "styles.xml";

    public XsltOdStreamTemplateCompiler(BdfServer bdfServer, PathConfiguration pathConfiguration, TemplateKey templateKey, MessageHandler messageHandler) {
        super(bdfServer, pathConfiguration, templateKey, messageHandler);
    }

    @Override
    public StreamTemplateFactory compile(TemplateStorage.Unit storageUnit) throws CompilationException {
        Contents contents = new Contents(storageUnit);
        ExtractionDef customExtractionDef = this.getExtractionDef(storageUnit, EXTRACTION_PATH, false);
        StreamTransformer streamTransformer = contents.getStreamTransformer();
        return new XsltStreamTemplateFactory(storageUnit.getTemplateDef().getAttributes(), customExtractionDef, streamTransformer);
    }

    private class Contents {
        private final TemplateStorage.Unit storageUnit;
        private final String baseURI;
        private String contentXslt;
        private byte[] stylesByteArray;
        private byte[] automaticStylesByteArray;

        Contents(TemplateStorage.Unit storageUnit) {
            this.storageUnit = storageUnit;
            this.baseURI = TemplateCompilerUtils.getBaseURI(storageUnit.getTemplateKey());
        }

        private StreamTransformer getStreamTransformer() throws CompilationException {
            TemplateContentDescriptionBuilder xsltDescriptionBuilder = this.initContentXslt();
            this.initStyles();
            String systemId = this.baseURI + XsltOdStreamTemplateCompiler.CONTENT_XSL;
            InternalStreamTransformerErrorHandler streamTransformerErrorHandler = new InternalStreamTransformerErrorHandler(systemId, xsltDescriptionBuilder);
            ODStreamTransformerBuilder odStreamTransformerBuilder = ODStreamTransformerBuilder.init(this.storageUnit.getTemplateKey().getExtension(), systemId, BdfURI.getURIResolver(XsltOdStreamTemplateCompiler.this.bdfServer, XsltOdStreamTemplateCompiler.this.pathConfiguration)).setStreamTransformerErrorHandler(streamTransformerErrorHandler).setPictureHandler(new BdfPictureHandler(XsltOdStreamTemplateCompiler.this.bdfServer, XsltOdStreamTemplateCompiler.this.pathConfiguration)).setContentXsl(this.contentXslt);
            if (this.stylesByteArray != null) {
                odStreamTransformerBuilder.setStyles(this.stylesByteArray);
            }
            if (this.automaticStylesByteArray != null) {
                odStreamTransformerBuilder.setContentAutomaticStyles(this.automaticStylesByteArray);
            }
            StreamTransformer streamTransformer = odStreamTransformerBuilder.toStreamTransformer();
            if (streamTransformerErrorHandler.withError()) {
                throw new CompilationException();
            }
            return streamTransformer;
        }

        private String initTemplateContent(String name) {
            String string;
            block11: {
                InputStream inputStream;
                try {
                    inputStream = TemplateCompilerUtils.getContentInputStream(this.storageUnit, name);
                }
                catch (IOException ioe) {
                    XsltOdStreamTemplateCompiler.this.addError("_ error.exception.transformation_io", name, ioe.getMessage());
                    return null;
                }
                if (inputStream == null) {
                    return null;
                }
                InputStream is = inputStream;
                try {
                    String result;
                    string = result = IOUtils.toString(is, "UTF-8");
                    if (is == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        XsltOdStreamTemplateCompiler.this.addError("_ error.exception.transformation_io", name, ioe.getMessage());
                        return null;
                    }
                }
                is.close();
            }
            return string;
        }

        private String initStylesCss() {
            String stylesCss = this.initTemplateContent(XsltOdStreamTemplateCompiler.STYLES_CSS);
            if (stylesCss == null) {
                stylesCss = DefaultTemplateUtils.getDefaultStylesCss();
            } else {
                TemplateContentDescriptionBuilder templateContentDescriptionBuilder = XsltOdStreamTemplateCompiler.this.newTemplateContentDescriptionBuilder(XsltOdStreamTemplateCompiler.STYLES_CSS, false);
            }
            ElementMaps elementMaps = XsltOdStreamTemplateCompiler.this.parseCss(stylesCss, this.baseURI, XsltOdStreamTemplateCompiler.STYLES_CSS);
            String automaticStylesString = StylesConversionEngine.toAutomaticStylesXml(elementMaps);
            try {
                this.automaticStylesByteArray = automaticStylesString.getBytes("UTF-8");
            }
            catch (IOException ioe) {
                throw new ShouldNotOccurException(ioe);
            }
            StringBuilder stylesBuf = new StringBuilder();
            try {
                StylesConversionEngine.appendAllStyles(stylesBuf, elementMaps);
            }
            catch (IOException ioe) {
                throw new ShouldNotOccurException(ioe);
            }
            return stylesBuf.toString();
        }

        private void initStyles() throws CompilationException {
            String stylesFragment = this.initStylesCss();
            String stylesXml = this.initTemplateContent(XsltOdStreamTemplateCompiler.STYLES_XML);
            if (stylesXml == null) {
                stylesXml = DefaultTemplateUtils.getDefaultStylesXML(XsltOdStreamTemplateCompiler.this.bdfServer);
                String testError = XMLUtils.testXml(stylesXml);
                if (testError != null) {
                    XsltOdStreamTemplateCompiler.this.addError("_ error.wrong.transformation.xml", BdfURI.toAbsoluteBdfURI("xml/odtstyles.xml"), testError);
                    throw new CompilationException();
                }
            } else {
                TemplateContentDescriptionBuilder templateContentDescriptionBuilder = XsltOdStreamTemplateCompiler.this.newTemplateContentDescriptionBuilder(XsltOdStreamTemplateCompiler.STYLES_XML, true);
                if (!TemplateCompilerUtils.testXml(stylesXml, templateContentDescriptionBuilder)) {
                    throw new CompilationException();
                }
            }
            int idx = stylesXml.indexOf(XsltOdStreamTemplateCompiler.CCS_MARKUP);
            String completeXml = stylesXml;
            if (idx != -1) {
                completeXml = stylesXml.substring(0, idx) + stylesFragment + stylesXml.substring(idx + XsltOdStreamTemplateCompiler.CCS_MARKUP.length());
            }
            try {
                this.stylesByteArray = completeXml.getBytes("UTF-8");
            }
            catch (IOException ioe) {
                throw new ShouldNotOccurException(ioe);
            }
        }

        private TemplateContentDescriptionBuilder initContentXslt() throws CompilationException {
            this.contentXslt = this.initTemplateContent(XsltOdStreamTemplateCompiler.CONTENT_XSL);
            if (this.contentXslt == null) {
                XsltOdStreamTemplateCompiler.this.addError("_ error.empty.transformation.ressource", XsltOdStreamTemplateCompiler.CONTENT_XSL);
                throw new CompilationException();
            }
            TemplateContentDescriptionBuilder templateContentDescriptionBuilder = XsltOdStreamTemplateCompiler.this.newTemplateContentDescriptionBuilder(XsltOdStreamTemplateCompiler.CONTENT_XSL, true);
            if (!TemplateCompilerUtils.testXml(this.contentXslt, templateContentDescriptionBuilder)) {
                throw new CompilationException();
            }
            return templateContentDescriptionBuilder;
        }
    }

    private class InternalStreamTransformerErrorHandler
    implements StreamTransformerErrorHandler {
        private final String systemId;
        private final TemplateContentDescriptionBuilder templateContentDescriptionBuilder;
        private boolean withError = false;

        private InternalStreamTransformerErrorHandler(String systemId, TemplateContentDescriptionBuilder templateContentDescriptionBuilder) {
            this.systemId = systemId;
            this.templateContentDescriptionBuilder = templateContentDescriptionBuilder;
        }

        @Override
        public void missingResourceError(String resourceURI) {
            XsltOdStreamTemplateCompiler.this.addError("_ error.empty.transformation.ressource", resourceURI);
            this.withError = true;
        }

        @Override
        public void transformerError(TransformerException transformerException) {
            LogUtils.handleTransformerException("error", transformerException, this.systemId, this.templateContentDescriptionBuilder);
            this.withError = true;
        }

        @Override
        public void transformerWarning(TransformerException transformerException) {
            LogUtils.handleTransformerException("warning", transformerException, this.systemId, this.templateContentDescriptionBuilder);
        }

        private boolean withError() {
            return this.withError;
        }
    }
}

