/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.exportation.transformation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.namespaces.BdfUserSpace;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.util.HashMap;
import java.util.Map;
import net.fichotheque.namespaces.TransformationSpace;
import net.fichotheque.sphere.Redacteur;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.localisation.Lang;

public class TransformerParameters {
    private final Map<String, Object> map = new HashMap<String, Object>();

    public TransformerParameters put(String name, Object value) {
        this.map.put(name, value);
        return this;
    }

    public TransformerParameters putAll(Map<String, Object> otherMap) {
        this.map.putAll(otherMap);
        return this;
    }

    public TransformerParameters check(Attributes attributes) {
        this.checkIncludeScripts(attributes);
        this.checkTextParameters(attributes, "TEXT_FIELDBULLET");
        this.checkTextParameters(attributes, "TEXT_SECTIONEND");
        this.checkWithParameters(attributes, "WITH_FICHENUMBER");
        this.checkWithParameters(attributes, "WITH_RESOURCELOGO");
        return this;
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    private void checkIncludeScripts(Attributes attributes) {
        Attribute attribute = attributes.getAttribute(BdfUserSpace.INCLUDESCRIPTS_KEY);
        if (attribute == null) {
            return;
        }
        String includeScripts = "";
        int size = attribute.size();
        if (size == 1) {
            includeScripts = attribute.getFirstValue();
        } else {
            StringBuilder buf = new StringBuilder();
            for (String value : attribute) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append(value);
            }
            includeScripts = buf.toString();
        }
        this.map.put("INCLUDESCRIPTS", includeScripts);
    }

    private void checkTextParameters(Attributes attributes, String name) {
        AttributeKey matchingKey = TransformerParameters.getMatchingAttributeKey(name);
        if (matchingKey == null) {
            return;
        }
        Attribute attribute = attributes.getAttribute(matchingKey);
        if (attribute == null) {
            return;
        }
        String value = attribute.getFirstValue();
        int length = value.length();
        if (length == 1) {
            if (value.charAt(48) == '\'') {
                value = "";
            }
        } else {
            if (value.charAt(length - 1) == '\'') {
                value = value.substring(0, length - 1);
            }
            if (value.charAt(0) == '\'') {
                value = value.substring(1);
            }
        }
        this.map.put(name, value);
    }

    private void checkWithParameters(Attributes attributes, String name) {
        AttributeKey matchingKey = TransformerParameters.getMatchingAttributeKey(name);
        if (matchingKey == null) {
            return;
        }
        Attribute attribute = attributes.getAttribute(matchingKey);
        if (attribute == null) {
            return;
        }
        this.map.put(name, attribute.getFirstValue());
    }

    public static TransformerParameters build(BdfParameters bdfParameters) {
        BdfServer bdfServer = bdfParameters.getBdfServer();
        BdfUser bdfUser = bdfParameters.getBdfUser();
        Redacteur redacteur = bdfUser.getRedacteur();
        boolean hideEmpty = bdfUser.getPrefs().getBoolean(BdfUserSpace.HIDEEMPTY_KEY);
        TransformerParameters transformerParameters = new TransformerParameters();
        transformerParameters.put("WORKINGLANG", bdfUser.getWorkingLang().toString()).put("BDF_VERSION", bdfServer.getBuildInfo().getVersion()).put("BDF_FICHOTHEQUEPATH", BdfUserUtils.getRootUrl(bdfUser)).put("SHOWEMPTY", hideEmpty ? 0 : 1).put("USER_SPHERE", redacteur.getSubsetName()).put("USER_LOGIN", redacteur.getLogin()).check(bdfServer.getFichotheque().getFichothequeMetadata().getAttributes());
        return transformerParameters;
    }

    public static TransformerParameters build(Lang workingLang) {
        TransformerParameters transformerParameters = new TransformerParameters();
        transformerParameters.put("WORKINGLANG", workingLang.toString());
        return transformerParameters;
    }

    private static AttributeKey getMatchingAttributeKey(String name) {
        switch (name) {
            case "TEXT_FIELDBULLET": {
                return TransformationSpace.FIELDBULLET_KEY;
            }
            case "TEXT_SECTIONEND": {
                return TransformationSpace.SECTIONEND_KEY;
            }
            case "WITH_FICHENUMBER": {
                return TransformationSpace.FICHENUMBER_KEY;
            }
            case "WITH_RESOURCELOGO": {
                return TransformationSpace.RESOURCELOGO_KEY;
            }
        }
        return null;
    }
}

