/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.implementations;

import fr.exemole.bdfserver.storage.directory.StorageDirectory;
import fr.exemole.bdfserver.storage.directory.bdfdata.DocumentDirectory;
import fr.exemole.bdfserver.storage.directory.bdfdata.Remove;
import fr.exemole.bdfserver.storage.directory.bdfdata.Save;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import net.fichotheque.EditOrigin;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.addenda.Document;
import net.fichotheque.addenda.VersionInfo;
import net.fichotheque.impl.AddendaDataSource;

public class AddendaDataSourceImpl
implements AddendaDataSource {
    private final StorageDirectory bdfdataDirectory;

    public AddendaDataSourceImpl(StorageDirectory bdfdataDirectory) {
        this.bdfdataDirectory = bdfdataDirectory;
    }

    @Override
    public void saveMetadata(Addenda addenda, EditOrigin editOrigin) {
        if (editOrigin == null) {
            throw new IllegalArgumentException("editOrigin is null");
        }
        Save.saveAddendaMetadata(this.bdfdataDirectory, addenda, editOrigin);
    }

    @Override
    public void saveDocument(Document document, EditOrigin editOrigin) {
        Save.saveDocument(this.bdfdataDirectory, document, editOrigin);
    }

    @Override
    public void removeDocument(Addenda addenda, int id, EditOrigin editOrign) {
        Remove.removeDocument(this.bdfdataDirectory, addenda, id, editOrign);
    }

    @Override
    public InputStream getInputStream(Document document, String extension) {
        DocumentDirectory documentDirectory = this.getDocumentDirectory(document);
        return documentDirectory.getInputStream(extension);
    }

    @Override
    public boolean deleteVersion(Document document, String extension) {
        DocumentDirectory documentDirectory = this.getDocumentDirectory(document);
        return documentDirectory.delete(extension);
    }

    @Override
    public VersionInfo saveVersion(Document document, String extension, InputStream inputStream) {
        DocumentDirectory documentDirectory = this.getDocumentDirectory(document);
        return documentDirectory.saveInputStream(extension, inputStream);
    }

    @Override
    public boolean linkTo(Document document, String extension, Path destination, boolean symbolicLink) throws IOException {
        DocumentDirectory documentDirectory = this.getDocumentDirectory(document);
        return documentDirectory.linkTo(extension, destination, symbolicLink);
    }

    private DocumentDirectory getDocumentDirectory(Document document) {
        return DocumentDirectory.getDocumentDirectory(this.bdfdataDirectory, document.getSubsetKey(), document.getId());
    }
}

