/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.bdfdata;

import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.text.AccoladeArgument;
import net.mapeadores.util.text.AccoladePattern;
import net.mapeadores.util.text.ValueResolver;

public class StartValues {
    public static final String AUTHORITY = "authority";
    public static final String BASENAME = "basename";
    public static final String WORKINGLANGS = "workinglangs";
    public static final String SPHERENAME = "spherename";
    public static final String FIRSTUSER = "firstuser";
    public static final String FIRSTPASSWORD = "firstpassword";
    private final Map<String, String> valueMap = new HashMap<String, String>();
    private final InternalResolver resolver = new InternalResolver();
    private Langs workingLangs = LangsUtils.toCleanLangs("fr");
    private Set<String> centralSphereSet = new LinkedHashSet<String>();

    public StartValues() {
        this.valueMap.put(AUTHORITY, "localhost");
        this.valueMap.put(BASENAME, "base");
        this.valueMap.put(SPHERENAME, "admin");
        this.valueMap.put(FIRSTUSER, "ADMIN");
        this.valueMap.put(FIRSTPASSWORD, "admin");
    }

    public String authority() {
        return this.valueMap.get(AUTHORITY);
    }

    public StartValues authority(String authority) {
        if (authority == null) {
            authority = "localhost";
        }
        this.put(AUTHORITY, authority);
        return this;
    }

    public String basename() {
        return this.valueMap.get(BASENAME);
    }

    public StartValues basename(String basename) {
        if (basename == null) {
            basename = "base";
        }
        this.put(BASENAME, basename);
        return this;
    }

    public Langs workingLangs() {
        return this.workingLangs;
    }

    public StartValues workingLangs(Langs langs) {
        if (!langs.isEmpty()) {
            this.workingLangs = langs;
        }
        return this;
    }

    public String spherename() {
        return this.valueMap.get(SPHERENAME);
    }

    public StartValues spherename(String spherename) {
        if (spherename == null) {
            spherename = "admin";
        }
        this.put(SPHERENAME, spherename);
        return this;
    }

    public String firstuser() {
        return this.valueMap.get(FIRSTUSER);
    }

    public StartValues firstuser(String firstuser) {
        if (firstuser == null) {
            firstuser = FIRSTUSER;
        }
        this.put(FIRSTUSER, firstuser);
        return this;
    }

    public String firstpassword() {
        return this.valueMap.get(FIRSTPASSWORD);
    }

    public StartValues firstpassword(String firstpassword) {
        if (firstpassword == null) {
            firstpassword = "admin";
        }
        this.put(FIRSTPASSWORD, firstpassword);
        return this;
    }

    public StartValues addCentralSphere(String centralSphereName) {
        this.centralSphereSet.add(centralSphereName);
        return this;
    }

    public Set<String> centralSpheres() {
        return this.centralSphereSet;
    }

    private void put(String key, String value) {
        this.valueMap.put(key, value);
    }

    public String replaceInText(String text) throws ParseException {
        AccoladePattern pattern = new AccoladePattern(text);
        return pattern.format(this.resolver);
    }

    public static StartValues init() {
        return new StartValues();
    }

    private class InternalResolver
    implements ValueResolver {
        private InternalResolver() {
        }

        @Override
        public String getValue(AccoladeArgument accoladeArgument) {
            String argumentName = accoladeArgument.getName();
            if (argumentName.equals(StartValues.WORKINGLANGS)) {
                StringBuilder buf = new StringBuilder();
                for (Lang lang : StartValues.this.workingLangs) {
                    buf.append("<working-lang lang=\"");
                    buf.append(lang.toString());
                    buf.append("\"/>\n");
                }
                return buf.toString();
            }
            String value = (String)StartValues.this.valueMap.get(argumentName);
            if (value != null) {
                return value;
            }
            return AccoladePattern.toString(accoladeArgument);
        }
    }
}

