/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.servlets.instructions;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.configuration.PathConfiguration;
import fr.exemole.bdfserver.api.instruction.BdfCommand;
import fr.exemole.bdfserver.api.instruction.BdfCommandParameters;
import fr.exemole.bdfserver.api.instruction.BdfCommandResult;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.interaction.Domain;
import fr.exemole.bdfserver.api.managers.BalayageManager;
import fr.exemole.bdfserver.api.managers.ScrutariExportManager;
import fr.exemole.bdfserver.api.managers.SqlExportManager;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.commands.CoreBdfCommandProvider;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.configuration.PathConfigurationBuilder;
import fr.exemole.bdfserver.tools.instruction.BdfCommandParametersBuilder;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import fr.exemole.bdfserver.tools.runners.BalayageRunner;
import fr.exemole.bdfserver.tools.runners.ScrutariExportRunner;
import fr.exemole.bdfserver.tools.runners.SqlExportRunner;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import net.fichotheque.exportation.balayage.BalayageDescription;
import net.fichotheque.exportation.scrutari.ScrutariExportDef;
import net.fichotheque.exportation.sql.SqlExportDef;
import net.mapeadores.util.ini.IniParser;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.request.RequestMapBuilder;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.JsonResponseHandler;
import net.mapeadores.util.servlets.handlers.SimpleResponseHandler;
import net.mapeadores.util.text.RelativePath;
import net.mapeadores.util.text.StringUtils;

public class RunInstruction
implements BdfInstruction {
    public static final String FILE_PARAMNAME = "file";
    public static final String SQLEXPORT_PARAMNAME = "sqlexport";
    public static final String SCRUTARIEXPORT_PARAMNAME = "scrutariexport";
    public static final String BALAYAGE_PARAMNAME = "balayage";
    private static final Domain DEFAULT_DOMAIN = new Domain("edition", "");
    private final BdfServer bdfServer;
    private final RequestMap requestMap;

    public RunInstruction(BdfServer bdfServer, RequestMap requestMap) {
        this.bdfServer = bdfServer;
        this.requestMap = requestMap;
    }

    @Override
    public short getBdfUserNeed() {
        return 1;
    }

    @Override
    public ResponseHandler runInstruction(BdfUser bdfUser) {
        String runFile = this.requestMap.getParameter(FILE_PARAMNAME);
        if (runFile != null) {
            RunFileEngine runFileEngine = new RunFileEngine(this.bdfServer, this.requestMap);
            return runFileEngine.run(runFile);
        }
        ExportEngine exportEngine = new ExportEngine(this.bdfServer, this.requestMap);
        return exportEngine.run();
    }

    static /* synthetic */ Domain access$1100() {
        return DEFAULT_DOMAIN;
    }

    private static class RunFileEngine {
        private final BdfServer bdfServer;
        private final RequestMap requestMap;

        private RunFileEngine(BdfServer bdfServer, RequestMap requestMap) {
            this.bdfServer = bdfServer;
            this.requestMap = requestMap;
        }

        private ResponseHandler run(String runFile) {
            JsonProducer jsonProducer;
            try {
                jsonProducer = this.innerRun(runFile);
            }
            catch (ErrorMessageException eme) {
                jsonProducer = BdfInstructionUtils.getDefaultJsonProducer(this.getMessageLocalisation(), null, eme.getErrorMessage());
            }
            return JsonResponseHandler.build(jsonProducer, this.requestMap);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private JsonProducer innerRun(String runFile) throws ErrorMessageException {
            RelativePath relativePath;
            try {
                relativePath = RelativePath.parse(runFile);
            }
            catch (ParseException pe) {
                throw BdfErrors.wrongParameterValue(RunInstruction.FILE_PARAMNAME, runFile);
            }
            String string = "var.run";
            synchronized ("var.run") {
                Path filePath = this.bdfServer.getBdfServerDirs().resolveSubPath("var.run", relativePath);
                if (!Files.exists(filePath, new LinkOption[0])) {
                    throw BdfErrors.error("_ error.unknown.file", relativePath.toString());
                }
                if (Files.isDirectory(filePath, new LinkOption[0])) {
                    throw BdfErrors.error("_ error.unsupported.directory", relativePath.toString());
                }
                RunFileParser parser = new RunFileParser();
                try {
                    parser.parse(filePath);
                }
                catch (IOException ioe) {
                    throw BdfErrors.error("_ error.exception.io_read", relativePath.toString());
                }
                if (!parser.hasCommand()) {
                    throw BdfErrors.emptyMandatoryParameter("_command");
                }
                if (!parser.keepFile) {
                    try {
                        Files.delete(filePath);
                    }
                    catch (IOException ioe) {
                        throw BdfErrors.error("_ error.exception.io_delete", relativePath.toString());
                    }
                }
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return this.runCommand(parser);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private JsonProducer runCommand(RunFileParser parser) throws ErrorMessageException {
            BdfCommandResult bdfCommandResult;
            BdfCommandParameters bdfCommandParameters = BdfCommandParametersBuilder.build(parser.command, parser.domain, this.bdfServer, parser.runRequestMap);
            BdfCommand bdfCommand = BdfServerUtils.getExtensionBdfCommand(bdfCommandParameters);
            if (bdfCommand == null) {
                bdfCommand = CoreBdfCommandProvider.UNIQUE_INSTANCE.getBdfCommand(bdfCommandParameters);
            }
            if (bdfCommand == null) {
                throw BdfErrors.error("_ error.unknown.bdfcommand", parser.command);
            }
            BdfUser defaultBdfUser = BdfUserUtils.getFirstAdminBdfUser(this.bdfServer);
            defaultBdfUser.putParameter("bdf.edit.alternateglobalid", "_run");
            if (bdfCommand.needSynchronisation()) {
                BdfServer bdfServer = this.bdfServer;
                synchronized (bdfServer) {
                    bdfCommandResult = bdfCommand.doCommand(defaultBdfUser);
                }
            } else {
                bdfCommandResult = bdfCommand.doCommand(defaultBdfUser);
            }
            return BdfInstructionUtils.getDefaultJsonProducer(this.getMessageLocalisation(), bdfCommandResult, null);
        }

        private MessageLocalisation getMessageLocalisation() {
            return BdfInstructionUtils.getMessageLocalisation(this.requestMap, this.bdfServer, null);
        }
    }

    private static class ExportEngine {
        private final BdfServer bdfServer;
        private final RequestMap requestMap;
        private final PathConfiguration pathConfiguration;

        private ExportEngine(BdfServer bdfServer, RequestMap requestMap) {
            this.bdfServer = bdfServer;
            this.requestMap = requestMap;
            this.pathConfiguration = PathConfigurationBuilder.build(bdfServer);
        }

        private ResponseHandler run() {
            String[] balayageArray;
            String[] scrutariExportArray;
            String[] sqlExportArray = this.requestMap.getParameterValues(RunInstruction.SQLEXPORT_PARAMNAME);
            int result = -1;
            if (sqlExportArray != null) {
                if (result == -1) {
                    result = 0;
                }
                result += this.runSqlExport(sqlExportArray);
            }
            if ((scrutariExportArray = this.requestMap.getParameterValues(RunInstruction.SCRUTARIEXPORT_PARAMNAME)) != null) {
                if (result == -1) {
                    result = 0;
                }
                result += this.runScrutariExport(scrutariExportArray);
            }
            if ((balayageArray = this.requestMap.getParameterValues(RunInstruction.BALAYAGE_PARAMNAME)) != null) {
                if (result == -1) {
                    result = 0;
                }
                result += this.runBalayage(balayageArray);
            }
            return SimpleResponseHandler.init(String.valueOf(result));
        }

        private int runSqlExport(String[] tokens) {
            int errorCount = 0;
            SqlExportManager sqlExportManager = this.bdfServer.getSqlExportManager();
            for (String token : tokens) {
                SqlExportDef sqlExportDef = sqlExportManager.getSqlExportDef(token);
                if (sqlExportDef != null) {
                    try {
                        CommandMessage message = SqlExportRunner.run(sqlExportDef, this.bdfServer, this.pathConfiguration, true);
                        if (!message.isErrorMessage()) continue;
                        ++errorCount;
                    }
                    catch (IOException ioe) {
                        ++errorCount;
                    }
                    continue;
                }
                ++errorCount;
            }
            return errorCount;
        }

        private int runScrutariExport(String[] tokens) {
            int result = 0;
            ScrutariExportManager scrutariExportManager = this.bdfServer.getScrutariExportManager();
            for (String token : tokens) {
                ScrutariExportDef scrutariExportDef = scrutariExportManager.getScrutariExportDef(token);
                if (scrutariExportDef != null) {
                    try {
                        ScrutariExportRunner.run(scrutariExportDef, this.bdfServer, this.pathConfiguration);
                    }
                    catch (IOException ioe) {
                        ++result;
                    }
                    continue;
                }
                ++result;
            }
            return result;
        }

        private int runBalayage(String[] tokens) {
            int result = 0;
            BalayageManager balayageManager = this.bdfServer.getBalayageManager();
            for (String balayageName : tokens) {
                BalayageDescription balayageDescription;
                String mode = null;
                int idx = balayageName.indexOf(47);
                if (idx != -1) {
                    mode = balayageName.substring(idx + 1);
                    balayageName = balayageName.substring(0, idx);
                }
                if ((balayageDescription = balayageManager.getBalayage(balayageName)) != null) {
                    BalayageRunner.Result balayageResult = BalayageRunner.run(balayageDescription, mode, this.bdfServer, this.pathConfiguration);
                    if (!balayageResult.hasError()) continue;
                    ++result;
                    continue;
                }
                ++result;
            }
            return result;
        }
    }

    private static class RunFileParser {
        private Domain domain = RunInstruction.access$1100();
        private RequestMap runRequestMap;
        private boolean keepFile = false;
        private String command;

        private RunFileParser() {
        }

        private void setDomain(String domainString) {
            this.domain = Domain.parse(domainString);
        }

        private void setKeepFile(String keepFileValue) {
            this.keepFile = StringUtils.isTrue(keepFileValue);
        }

        private void setCommand(String command) {
            this.command = command;
        }

        private boolean hasCommand() {
            return this.command != null && !this.command.isEmpty();
        }

        private void parse(Path filePath) throws IOException {
            RequestMapBuilder requestMapBuilder = new RequestMapBuilder();
            try (InputStream is = Files.newInputStream(filePath, new OpenOption[0]);){
                IniParser.parseIni(is, (key, value) -> {
                    switch (key) {
                        case "_domain": {
                            this.setDomain((String)value);
                            break;
                        }
                        case "_keep": {
                            this.setKeepFile((String)value);
                            break;
                        }
                        case "_command": 
                        case "cmd": {
                            this.setCommand((String)value);
                            requestMapBuilder.addParameter("cmd", (String)value);
                            break;
                        }
                        default: {
                            requestMapBuilder.addParameter((String)key, (String)value);
                        }
                    }
                });
            }
            this.runRequestMap = requestMapBuilder.toRequestMap();
        }
    }
}

