/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.subscribe;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.multi.api.MultiMetadata;
import fr.exemole.bdfserver.multi.commands.CreationParameters;
import fr.exemole.bdfserver.multi.subscribe.SubscribeCommand;
import fr.exemole.bdfserver.multi.subscribe.SubscribeParameters;
import fr.exemole.bdfserver.multi.subscribe.SubscribeResult;
import fr.exemole.bdfserver.multi.subscribe.SubscribeToken;
import fr.exemole.bdfserver.storage.directory.bdfdata.StartValues;
import java.text.ParseException;
import net.fichotheque.SubsetKey;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.sphere.SphereEditor;
import net.fichotheque.utils.SphereUtils;
import net.mapeadores.util.logging.ErrorMessageException;

public class FichothequeSubscribeCommand
extends SubscribeCommand {
    public static final String COMMAND_NAME = "FichothequeSubscribe";
    public static final String TOKEN_PARAMNAME = "token";
    public static final String NEWFICHOTHEQUE_PARAMNAME = "newfichotheque";
    public static final String FIRSTSPHERE_PARAMNAME = "firstsphere";
    public static final String FIRSTUSER_PARAMNAME = "firstuser";
    public static final String FIRSTPASSWORD1_PARAMNAME = "firstpassword_1";
    public static final String FIRSTPASSWORD2_PARAMNAME = "firstpassword_2";
    private String fichothequeName;
    private StartValues startValues;
    private SubscribeToken subscribeToken;

    public FichothequeSubscribeCommand(SubscribeParameters subscribeParameters) {
        super(subscribeParameters);
    }

    @Override
    public SubscribeResult doSubscribeCommand() throws ErrorMessageException {
        this.testCommand();
        this.multi.createFichotheque(CreationParameters.initNew(this.fichothequeName, this.startValues));
        this.subscribeToken.setUsed(true);
        this.populateFichotheque(this.multi.getBdfServer(this.fichothequeName), this.startValues, this.subscribeToken);
        return SubscribeResult.init(this.subscribeParameters).fichothequeName(this.fichothequeName).login(this.startValues.firstuser());
    }

    @Override
    public void testCommand() throws ErrorMessageException {
        MultiMetadata multiMetadata = this.multi.getMultiMetadata();
        String token = this.getMandatory(TOKEN_PARAMNAME);
        this.subscribeToken = SubscribeCommand.getValidToken(this.subscribeParameters, token);
        this.fichothequeName = this.getFichothequeName(NEWFICHOTHEQUE_PARAMNAME);
        if (this.multi.containsFichotheque(this.fichothequeName)) {
            throw new ErrorMessageException("_ error.existing.fichotheque", this.fichothequeName);
        }
        this.startValues = this.getStartValues().authority(multiMetadata.getAuthority()).basename(this.fichothequeName).workingLangs(multiMetadata.getWorkingLangs());
    }

    private StartValues getStartValues() throws ErrorMessageException {
        SubsetKey sphereKey;
        String sphereName = this.getMandatory(FIRSTSPHERE_PARAMNAME);
        String firstUser = this.getMandatory(FIRSTUSER_PARAMNAME);
        String password1 = this.getMandatory(FIRSTPASSWORD1_PARAMNAME);
        String password2 = this.getMandatory(FIRSTPASSWORD2_PARAMNAME);
        try {
            sphereKey = SubsetKey.parse((short)3, sphereName);
        }
        catch (ParseException pe) {
            throw new ErrorMessageException("_ error.wrong.spherename", sphereName);
        }
        if (!SphereUtils.testLogin(firstUser)) {
            throw new ErrorMessageException("_ error.wrong.login", firstUser);
        }
        if (!password1.equals(password2)) {
            throw new ErrorMessageException("_ error.wrong.password_different");
        }
        return StartValues.init().spherename(sphereKey.getSubsetName()).firstuser(firstUser).firstpassword(password1);
    }

    private void populateFichotheque(BdfServer bdfServer, StartValues startValues, SubscribeToken subscribeToken) {
        SubsetKey sphereKey = SubsetKey.build((short)3, startValues.spherename());
        String login = startValues.firstuser();
        Redacteur redacteur = ((Sphere)bdfServer.getFichotheque().getSubset(sphereKey)).getRedacteurByLogin(login);
        try (EditSession editSession = bdfServer.initEditSession("_admin", COMMAND_NAME);){
            SphereEditor sphereEditor = editSession.getFichothequeEditor().getSphereEditor(sphereKey);
            sphereEditor.setPerson(redacteur, subscribeToken.getPerson());
            sphereEditor.setEmail(redacteur, subscribeToken.getEmail());
        }
    }
}

