/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.commands.central;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.managers.PermissionManager;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.api.central.CentralSphere;
import fr.exemole.bdfserver.multi.commands.central.AbstractCentralMultiCommand;
import fr.exemole.bdfserver.multi.tools.PresenceInfo;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.util.List;
import net.fichotheque.sphere.Redacteur;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class CentralStatusChangeCommand
extends AbstractCentralMultiCommand {
    public static final String COMMAND_NAME = "CentralStatusChange";

    public CentralStatusChangeCommand(Multi multi, RequestMap requestMap) {
        super(multi, requestMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandMessage doCommand() throws ErrorMessageException {
        boolean done;
        this.initCentralSphere();
        this.initCentralUser();
        String status = this.getStatus();
        List<PresenceInfo> presenceInfoList = PresenceInfo.scan(this.multi, this.centralUser, false);
        if (status.equals("inactive")) {
            this.checkUniqueAdmin(presenceInfoList);
        }
        this.initCentralEditors();
        CentralSphere centralSphere = this.getCentralSphere();
        synchronized (centralSphere) {
            done = this.getCentralUserEditor().setStatus(status);
            this.saveChanges();
        }
        if (done && status.equals("inactive")) {
            for (PresenceInfo presenceInfo : presenceInfoList) {
                BdfServer currentBdfServer;
                Redacteur redacteur = presenceInfo.getRedacteur();
                if (redacteur == null || redacteur.getStatus().equals(status)) continue;
                BdfServer bdfServer = currentBdfServer = presenceInfo.getBdfServer();
                synchronized (bdfServer) {
                    try (EditSession editSession = this.newEditSession(currentBdfServer, COMMAND_NAME);){
                        if (currentBdfServer.getPermissionManager().isAdmin(redacteur)) {
                            editSession.getBdfServerEditor().setAdmin(redacteur.getGlobalId(), false);
                        }
                        editSession.getFichothequeEditor().getSphereEditor(redacteur.getSubsetKey()).setStatus(redacteur, status);
                    }
                }
            }
        }
        if (done) {
            return this.done("_ done.sphere.redacteurstatus");
        }
        return null;
    }

    private String getStatus() throws ErrorMessageException {
        String status;
        switch (status = this.getMandatory("status")) {
            case "active": 
            case "readonly": 
            case "inactive": {
                return status;
            }
        }
        throw BdfErrors.unknownParameterValue("status", status);
    }

    private void checkUniqueAdmin(List<PresenceInfo> presenceInfoList) throws ErrorMessageException {
        for (PresenceInfo presenceInfo : presenceInfoList) {
            BdfServer currentBdfServer;
            PermissionManager permissionManager;
            Redacteur redacteur = presenceInfo.getRedacteur();
            if (redacteur == null || !(permissionManager = (currentBdfServer = presenceInfo.getBdfServer()).getPermissionManager()).isAdmin(redacteur) || permissionManager.getAdminRedacteurList().size() >= 2) continue;
            throw new ErrorMessageException("_ error.unsupported.lastadmin_fichotheque", currentBdfServer.getName());
        }
    }
}

