/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.pioche;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.jsonproducers.pioche.CodeArrayJsonProducer;
import fr.exemole.bdfserver.jsonproducers.pioche.DocumentArrayJsonProducer;
import fr.exemole.bdfserver.jsonproducers.pioche.ExternalItemArrayJsonProducer;
import fr.exemole.bdfserver.jsonproducers.pioche.FicheArrayJsonProducer;
import fr.exemole.bdfserver.jsonproducers.pioche.FieldArrayJsonProducer;
import fr.exemole.bdfserver.jsonproducers.pioche.MotcleArrayJsonProducer;
import fr.exemole.bdfserver.jsonproducers.pioche.UserArrayJsonProducer;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.externalsource.ExternalSourceUtils;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import fr.exemole.bdfserver.tools.instruction.OutputRequestHandler;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.addenda.Document;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.externalsource.ExternalItem;
import net.fichotheque.externalsource.ExternalSource;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.selection.DocumentQuery;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.MotcleQuery;
import net.fichotheque.selection.MotcleSelector;
import net.fichotheque.selection.RedacteurQuery;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.selection.SubsetCondition;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.permission.PermissionUtils;
import net.fichotheque.tools.selection.DocumentQueryBuilder;
import net.fichotheque.tools.selection.FicheQueryBuilder;
import net.fichotheque.tools.selection.MotcleQueryBuilder;
import net.fichotheque.tools.selection.RedacteurQueryBuilder;
import net.fichotheque.tools.selection.SelectionDOMUtils;
import net.fichotheque.tools.selection.SelectionEngines;
import net.fichotheque.tools.thesaurus.sortprecedence.PrecedenceComparator;
import net.fichotheque.utils.AddendaUtils;
import net.fichotheque.utils.Comparators;
import net.fichotheque.utils.CorpusUtils;
import net.fichotheque.utils.SelectionUtils;
import net.fichotheque.utils.ThesaurusUtils;
import net.fichotheque.utils.selection.DocumentSelectorBuilder;
import net.fichotheque.utils.selection.FicheSelectorBuilder;
import net.fichotheque.utils.selection.MotcleSelectorBuilder;
import net.fichotheque.utils.selection.RedacteurSelectorBuilder;
import net.mapeadores.util.conditions.ConditionsUtils;
import net.mapeadores.util.conditions.TextCondition;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.localisation.CodeCatalog;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class PiocheJsonProducerFactory {
    private PiocheJsonProducerFactory() {
    }

    public static JsonProducer getJsonProducer(OutputParameters parameters) throws ErrorMessageException {
        OutputRequestHandler requestHandler = OutputRequestHandler.init(parameters);
        String json = parameters.getOutput();
        BdfServer bdfServer = parameters.getBdfServer();
        RequestMap requestMap = parameters.getRequestMap();
        BdfUser bdfUser = parameters.getBdfUser();
        Lang lang = parameters.getWorkingLang();
        try {
            lang = Lang.parse(requestMap.getParameter("lang"));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        switch (json) {
            case "document": {
                return new DocumentArrayJsonProducer(PiocheJsonProducerFactory.getDocuments(requestHandler));
            }
            case "fiche": {
                return new FicheArrayJsonProducer(parameters.getPermissionSummary(), PiocheJsonProducerFactory.getFiches(requestHandler), BdfInstructionUtils.getCellConverter(parameters));
            }
            case "motcle": {
                return new MotcleArrayJsonProducer(lang, PiocheJsonProducerFactory.getMotcles(requestHandler, lang), BdfInstructionUtils.getCellConverter(parameters));
            }
            case "externalitem": {
                return new ExternalItemArrayJsonProducer(PiocheJsonProducerFactory.getExternalItems(requestHandler, lang));
            }
            case "user": {
                return new UserArrayJsonProducer(PiocheJsonProducerFactory.getRedacteurs(requestHandler), PiocheJsonProducerFactory.getDefaultSphereKey(requestHandler));
            }
            case "language": {
                return new CodeArrayJsonProducer(bdfServer, bdfUser, PiocheJsonProducerFactory.getLangCodeSet(requestHandler));
            }
            case "country": {
                return new CodeArrayJsonProducer(bdfServer, bdfUser, PiocheJsonProducerFactory.getCountryCodeSet(requestHandler));
            }
            case "field": {
                TextCondition condition = PiocheJsonProducerFactory.getCondition(requestHandler);
                FieldArrayJsonProducer fieldArrayJsonProducer = new FieldArrayJsonProducer(bdfServer, bdfUser.getLangPreference(), PiocheJsonProducerFactory.getFieldType(requestHandler));
                fieldArrayJsonProducer.init(condition);
                return fieldArrayJsonProducer;
            }
        }
        return null;
    }

    private static SubsetKey getDefaultSphereKey(OutputRequestHandler requestHandler) {
        String param = requestHandler.getTrimedParameter("defaultsphere");
        if (param.isEmpty()) {
            return null;
        }
        try {
            SubsetKey sphereKey = SubsetKey.parse(param);
            if (sphereKey.isSphereSubset()) {
                return sphereKey;
            }
            return null;
        }
        catch (ParseException pe) {
            return null;
        }
    }

    private static String getFieldType(OutputRequestHandler requestHandler) {
        String param = requestHandler.getTrimedParameter("fieldtype");
        if (param.isEmpty()) {
            return "all";
        }
        return param;
    }

    private static SubsetKey getJunctionSubsetKey(OutputRequestHandler requestHandler) throws ErrorMessageException {
        String subsetString = requestHandler.getTrimedParameter("junction");
        if (subsetString.isEmpty()) {
            return null;
        }
        try {
            SubsetKey subsetKey = SubsetKey.parse(subsetString);
            return subsetKey;
        }
        catch (ParseException pe) {
            throw BdfErrors.wrongParameterValue("junction", subsetString);
        }
    }

    private static TextCondition getCondition(OutputRequestHandler requestHandler) throws ErrorMessageException {
        String q = requestHandler.getMandatoryParameter("q");
        return ConditionsUtils.parseSimpleCondition(q);
    }

    private static Collection<ExternalItem> getExternalItems(OutputRequestHandler requestHandler, Lang lang) throws ErrorMessageException {
        int limit;
        Thesaurus thesaurus;
        BdfServer bdfServer = requestHandler.getBdfServer();
        ExternalSource externalSource = ExternalSourceUtils.getExternalSource(bdfServer, thesaurus = PiocheJsonProducerFactory.getThesaurus(requestHandler));
        if (externalSource == null) {
            throw BdfErrors.wrongParameterValue("thesaurus or subsets", thesaurus.getSubsetName());
        }
        lang = BdfServerUtils.checkLangDisponibility(bdfServer, thesaurus, lang);
        String q = requestHandler.getMandatoryParameter("q");
        if (q.isEmpty()) {
            return ExternalSourceUtils.EXTERNALITEM_EMPTYLIST;
        }
        Collection<ExternalItem> result = externalSource.search(q, lang);
        Comparator<ExternalItem> comparator = PiocheJsonProducerFactory.getExternalItemComparator(requestHandler);
        if (comparator != null) {
            TreeSet<ExternalItem> treeset = new TreeSet<ExternalItem>(comparator);
            treeset.addAll(result);
            result = treeset;
        }
        if ((limit = PiocheJsonProducerFactory.getLimit(requestHandler)) < 1 || result.size() <= limit) {
            return result;
        }
        int p = 0;
        ArrayList<ExternalItem> list = new ArrayList<ExternalItem>(limit);
        for (ExternalItem externalItem : result) {
            list.add(externalItem);
            if (++p != limit) continue;
            break;
        }
        return list;
    }

    private static Collection<FicheMeta> getFiches(OutputRequestHandler requestHandler) throws ErrorMessageException {
        FicheQuery ficheQuery;
        SelectionContext selectionContext;
        block15: {
            TextCondition condition;
            Map<SubsetKey, Corpus> corpusMap;
            block14: {
                org.w3c.dom.Document document;
                selectionContext = BdfServerUtils.initSelectionContextBuilder(requestHandler).setSubsetAccessPredicate(requestHandler.getPermissionSummary().getSubsetAccessPredicate()).setFichePredicate(PermissionUtils.getFichePredicate(requestHandler.getPermissionSummary())).toSelectionContext();
                corpusMap = PiocheJsonProducerFactory.getCorpusMap(requestHandler);
                String xml = requestHandler.getTrimedParameter("xml", true);
                if (xml == null) break block14;
                try {
                    document = DOMUtils.parseDocument(xml);
                }
                catch (SAXException sae) {
                    throw BdfErrors.error("_ error.exception.xml.sax", sae.getMessage());
                }
                Element root = document.getDocumentElement();
                switch (root.getTagName()) {
                    case "fiche-query": 
                    case "fiche-select": {
                        ficheQuery = SelectionDOMUtils.getFicheConditionEntry(requestHandler.getFichotheque(), root).getFicheQuery();
                        if (!corpusMap.isEmpty()) {
                            ficheQuery = PiocheJsonProducerFactory.derive(ficheQuery, corpusMap);
                            break;
                        }
                        break block15;
                    }
                    default: {
                        throw BdfErrors.error("_ error.wrong.xml.root", root.getTagName(), "fiche-query");
                    }
                }
                break block15;
            }
            FicheQueryBuilder ficheQueryBuilder = FicheQueryBuilder.init().addCorpus(corpusMap.keySet());
            String q = requestHandler.getTrimedParameter("q");
            if (!q.isEmpty() && (condition = ConditionsUtils.parseSimpleCondition(q)) != null) {
                ficheQueryBuilder.setFieldContentCondition(condition, "title", null);
            }
            ficheQuery = ficheQueryBuilder.toFicheQuery();
        }
        if (ficheQuery != null) {
            Comparator<FicheMeta> comparator = requestHandler.getComparator(selectionContext.getWorkingLang());
            Collection<FicheMeta> result = SelectionEngines.run(selectionContext, FicheSelectorBuilder.init(selectionContext).add(ficheQuery).toFicheSelector(), comparator);
            int limit = PiocheJsonProducerFactory.getLimit(requestHandler);
            if (limit < 1 || result.size() <= limit) {
                return result;
            }
            int p = 0;
            ArrayList<FicheMeta> list = new ArrayList<FicheMeta>(limit);
            for (FicheMeta ficheMeta : result) {
                list.add(ficheMeta);
                if (++p != limit) continue;
                break;
            }
            return list;
        }
        return CorpusUtils.EMPTY_FICHEMETALIST;
    }

    private static Collection<Motcle> getMotcles(OutputRequestHandler requestHandler, Lang lang) throws ErrorMessageException {
        MotcleQuery motcleQuery;
        SelectionContext selectionContext;
        SubsetKey shouldNotJunctionSubsetKey;
        block16: {
            TextCondition condition;
            Map<SubsetKey, Thesaurus> thesaurusMap;
            RequestMap requestMap;
            block15: {
                org.w3c.dom.Document document;
                requestMap = requestHandler.getRequestMap();
                thesaurusMap = PiocheJsonProducerFactory.getThesaurusMap(requestHandler);
                shouldNotJunctionSubsetKey = PiocheJsonProducerFactory.getJunctionSubsetKey(requestHandler);
                if (thesaurusMap.size() == 1) {
                    Thesaurus thesaurus = thesaurusMap.values().iterator().next();
                    lang = BdfServerUtils.checkLangDisponibility(requestHandler.getBdfServer(), thesaurus, lang);
                }
                selectionContext = BdfServerUtils.initSelectionContextBuilder(requestHandler.getBdfServer(), lang).setSubsetAccessPredicate(requestHandler.getPermissionSummary().getSubsetAccessPredicate()).toSelectionContext();
                String xml = requestMap.getParameter("xml");
                if (xml == null) break block15;
                try {
                    document = DOMUtils.parseDocument(xml);
                }
                catch (SAXException sae) {
                    throw BdfErrors.error("_ error.exception.xml.sax", sae.getMessage());
                }
                Element root = document.getDocumentElement();
                switch (root.getTagName()) {
                    case "motcle-query": 
                    case "motcle-select": {
                        motcleQuery = SelectionDOMUtils.getMotcleConditionEntry(requestHandler.getFichotheque(), root).getMotcleQuery();
                        if (!thesaurusMap.isEmpty()) {
                            motcleQuery = PiocheJsonProducerFactory.derive(motcleQuery, thesaurusMap);
                            break;
                        }
                        break block16;
                    }
                    default: {
                        throw BdfErrors.error("_ error.wrong.xml.root", root.getTagName(), "motcle-query");
                    }
                }
                break block16;
            }
            MotcleQueryBuilder motcleQueryBuilder = MotcleQueryBuilder.init().addThesaurus(thesaurusMap.keySet());
            String q = requestMap.getParameter("q");
            if (q != null && (condition = ConditionsUtils.parseSimpleCondition(q)) != null) {
                motcleQueryBuilder.setContentCondition(condition, "idalpha_with");
            }
            motcleQuery = motcleQueryBuilder.toMotcleQuery();
        }
        if (motcleQuery != null) {
            MotcleSelector motcleSelector = MotcleSelectorBuilder.init(selectionContext).add(motcleQuery).toMotcleSelector();
            Comparator<Motcle> comparator = PiocheJsonProducerFactory.getMotcleComparator(requestHandler, selectionContext.getWorkingLang(), motcleSelector);
            Collection<Motcle> result = SelectionEngines.run(selectionContext, shouldNotJunctionSubsetKey, motcleSelector, comparator);
            int limit = PiocheJsonProducerFactory.getLimit(requestHandler);
            if (limit < 1 || result.size() <= limit) {
                return result;
            }
            int p = 0;
            ArrayList<Motcle> list = new ArrayList<Motcle>(limit);
            for (Motcle motcle : result) {
                list.add(motcle);
                if (++p != limit) continue;
                break;
            }
            return list;
        }
        return ThesaurusUtils.EMPTY_MOTCLELIST;
    }

    private static Collection<Document> getDocuments(OutputRequestHandler requestHandler) throws ErrorMessageException {
        RequestMap requestMap = requestHandler.getRequestMap();
        Map<SubsetKey, Addenda> addendaMap = PiocheJsonProducerFactory.getAddendaMap(requestHandler);
        if (addendaMap.isEmpty()) {
            return AddendaUtils.EMPTY_DOCUMENTLIST;
        }
        SelectionContext selectionContext = BdfServerUtils.initSelectionContextBuilder(requestHandler).setSubsetAccessPredicate(requestHandler.getPermissionSummary().getSubsetAccessPredicate()).toSelectionContext();
        TextCondition condition = PiocheJsonProducerFactory.getCondition(requestHandler);
        DocumentQuery documentQuery = DocumentQueryBuilder.init().addAddenda(addendaMap.keySet()).setNameCondition(condition).toDocumentQuery();
        return SelectionEngines.run(selectionContext, DocumentSelectorBuilder.init(selectionContext).add(documentQuery, null).toDocumentSelector());
    }

    private static Collection<Redacteur> getRedacteurs(OutputRequestHandler requestHandler) throws ErrorMessageException {
        Map<SubsetKey, Sphere> sphereMap = PiocheJsonProducerFactory.getSphereMap(requestHandler);
        SelectionContext selectionContext = BdfServerUtils.initSelectionContextBuilder(requestHandler).setSubsetAccessPredicate(requestHandler.getPermissionSummary().getSubsetAccessPredicate()).toSelectionContext();
        TextCondition condition = PiocheJsonProducerFactory.getCondition(requestHandler);
        RedacteurQuery redacteurQuery = RedacteurQueryBuilder.init().addSphere(sphereMap.keySet()).setNomcompletCondition(condition).toRedacteurQuery();
        return SelectionEngines.run(selectionContext, RedacteurSelectorBuilder.init(selectionContext).add(redacteurQuery).toRedacteurSelector());
    }

    private static Set<String> getCountryCodeSet(OutputRequestHandler requestHandler) throws ErrorMessageException {
        TextCondition condition = PiocheJsonProducerFactory.getCondition(requestHandler);
        CodeCatalog codeCatalog = requestHandler.getBdfServer().getL10nManager().getCodeCatalog();
        if (condition != null) {
            return codeCatalog.getCountryCodeSet(condition, requestHandler.getBdfUser().getLangPreference());
        }
        return codeCatalog.getCountryCodeSet();
    }

    private static Set<String> getLangCodeSet(OutputRequestHandler requestHandler) throws ErrorMessageException {
        TextCondition condition = PiocheJsonProducerFactory.getCondition(requestHandler);
        CodeCatalog codeCatalog = requestHandler.getBdfServer().getL10nManager().getCodeCatalog();
        if (condition != null) {
            return codeCatalog.getLangCodeSet(condition, requestHandler.getBdfUser().getLangPreference());
        }
        return codeCatalog.getLangCodeSet();
    }

    private static FicheQuery derive(FicheQuery originFicheQuery, Map<SubsetKey, Corpus> corpusMap) {
        SubsetCondition originSubsetCondition = originFicheQuery.getCorpusCondition();
        HashSet<SubsetKey> result = new HashSet<SubsetKey>();
        for (SubsetKey key : corpusMap.keySet()) {
            if (!originSubsetCondition.accept(key)) continue;
            result.add(key);
        }
        if (result.isEmpty()) {
            return originFicheQuery;
        }
        return SelectionUtils.derive(originFicheQuery, SelectionUtils.toSubsetCondition(result));
    }

    private static MotcleQuery derive(MotcleQuery originMotcleQuery, Map<SubsetKey, Thesaurus> thesaurusMap) {
        SubsetCondition originSubsetCondition = originMotcleQuery.getThesaurusCondition();
        HashSet<SubsetKey> result = new HashSet<SubsetKey>();
        for (SubsetKey key : thesaurusMap.keySet()) {
            if (!originSubsetCondition.accept(key)) continue;
            result.add(key);
        }
        if (result.isEmpty()) {
            return originMotcleQuery;
        }
        return SelectionUtils.derive(originMotcleQuery, SelectionUtils.toSubsetCondition(result));
    }

    private static Map<SubsetKey, Corpus> getCorpusMap(OutputRequestHandler requestHandler) throws ErrorMessageException {
        Fichotheque fichotheque = requestHandler.getFichotheque();
        LinkedHashMap<SubsetKey, Corpus> map = new LinkedHashMap<SubsetKey, Corpus>();
        String subsetsParam = requestHandler.getTrimedParameter("subsets");
        String[] corpusArray = StringUtils.getTechnicalTokens(subsetsParam, true);
        if (corpusArray.length > 0) {
            for (String corpusName : corpusArray) {
                Corpus corpus = fichotheque.getCorpus(corpusName);
                if (corpus == null) continue;
                map.put(corpus.getSubsetKey(), corpus);
            }
            if (map.isEmpty()) {
                throw BdfErrors.wrongParameterValue("subsets", subsetsParam);
            }
        }
        return map;
    }

    private static Map<SubsetKey, Thesaurus> getThesaurusMap(OutputRequestHandler requestHandler) throws ErrorMessageException {
        Fichotheque fichotheque = requestHandler.getFichotheque();
        LinkedHashMap<SubsetKey, Thesaurus> map = new LinkedHashMap<SubsetKey, Thesaurus>();
        String subsetsParam = requestHandler.getTrimedParameter("subsets");
        String[] thesaurusArray = StringUtils.getTechnicalTokens(subsetsParam, true);
        if (thesaurusArray.length > 0) {
            for (String thesaurusName : thesaurusArray) {
                Thesaurus thesaurus = fichotheque.getThesaurus(thesaurusName);
                if (thesaurus == null) continue;
                map.put(thesaurus.getSubsetKey(), thesaurus);
            }
            if (map.isEmpty()) {
                throw BdfErrors.wrongParameterValue("subsets", subsetsParam);
            }
        }
        return map;
    }

    private static Map<SubsetKey, Addenda> getAddendaMap(OutputRequestHandler requestHandler) throws ErrorMessageException {
        Fichotheque fichotheque = requestHandler.getFichotheque();
        PermissionSummary permissionSummary = requestHandler.getPermissionSummary();
        String subsetsParam = requestHandler.getTrimedParameter("subsets");
        LinkedHashMap<SubsetKey, Addenda> map = new LinkedHashMap<SubsetKey, Addenda>();
        String[] addendaArray = StringUtils.getTechnicalTokens(subsetsParam, true);
        if (addendaArray.length > 0) {
            for (String addendaName : addendaArray) {
                Addenda addenda = fichotheque.getAddenda(addendaName);
                if (addenda == null || !permissionSummary.isSubsetAdmin(addenda.getSubsetKey())) continue;
                map.put(addenda.getSubsetKey(), addenda);
            }
        } else {
            for (Addenda addenda : fichotheque.getAddendaList()) {
                if (!permissionSummary.isSubsetAdmin(addenda.getSubsetKey())) continue;
                map.put(addenda.getSubsetKey(), addenda);
            }
        }
        return map;
    }

    private static Map<SubsetKey, Sphere> getSphereMap(OutputRequestHandler requestHandler) throws ErrorMessageException {
        Fichotheque fichotheque = requestHandler.getFichotheque();
        String subsetsParam = requestHandler.getTrimedParameter("subsets");
        LinkedHashMap<SubsetKey, Sphere> map = new LinkedHashMap<SubsetKey, Sphere>();
        String[] sphereArray = StringUtils.getTechnicalTokens(subsetsParam, true);
        if (sphereArray.length > 0) {
            for (String sphereName : sphereArray) {
                Sphere sphere = fichotheque.getSphere(sphereName);
                if (sphere == null) continue;
                map.put(sphere.getSubsetKey(), sphere);
            }
            if (map.isEmpty()) {
                throw BdfErrors.wrongParameterValue("subsets", subsetsParam);
            }
        }
        return map;
    }

    private static Comparator<ExternalItem> getExternalItemComparator(OutputRequestHandler requestHandler) throws ErrorMessageException {
        String sort = requestHandler.getTrimedParameter("sort");
        if (sort.isEmpty()) {
            return null;
        }
        switch (sort) {
            case "id-asc": {
                return Comparators.EXTERNALITEMID_ASC;
            }
            case "id-desc": {
                return Comparators.EXTERNALITEMID_DESC;
            }
        }
        throw BdfErrors.error("_ error.unknown.parametervalue", "sort", sort);
    }

    private static Comparator<Motcle> getMotcleComparator(OutputRequestHandler requestHandler, Lang lang, MotcleSelector motcleSelector) throws ErrorMessageException {
        String sortPrecedence = requestHandler.getTrimedParameter("sortprecedence");
        if (!sortPrecedence.isEmpty()) {
            return new PrecedenceComparator(sortPrecedence, lang);
        }
        String sort = requestHandler.getTrimedParameter("sort");
        if (sort.isEmpty()) {
            List<Thesaurus> thesaurusList = motcleSelector.getThesaurusList();
            if (thesaurusList.size() == 1) {
                if (thesaurusList.get(0).isIdalphaType()) {
                    return null;
                }
                return Comparators.label(lang);
            }
            return Comparators.idalphaAndLabel(lang);
        }
        switch (sort) {
            case "id-asc": {
                return Comparators.MOTCLEID_ASC;
            }
            case "id-desc": {
                return Comparators.MOTCLEID_DESC;
            }
        }
        throw BdfErrors.error("_ error.unknown.parametervalue", "sort", sort);
    }

    private static int getLimit(OutputRequestHandler requestHandler) {
        String limitString = requestHandler.getTrimedParameter("limit");
        if (limitString.isEmpty()) {
            return -1;
        }
        try {
            return Integer.parseInt(limitString);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    private static Thesaurus getThesaurus(OutputRequestHandler requestHandler) throws ErrorMessageException {
        if (!requestHandler.getTrimedParameter("thesaurus").isEmpty()) {
            return requestHandler.getMandatoryThesaurus();
        }
        String subsetsParam = requestHandler.getMandatoryParameter("subsets");
        Map<SubsetKey, Thesaurus> thesaurusMap = PiocheJsonProducerFactory.getThesaurusMap(requestHandler);
        if (thesaurusMap.isEmpty()) {
            throw BdfErrors.wrongParameterValue("subsets", subsetsParam);
        }
        return thesaurusMap.values().iterator().next();
    }
}

