/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.edition;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import java.io.IOException;
import java.util.HashMap;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.format.FormatContext;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.FicheBlockFormatter;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.utils.FormatterUtils;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProperty;

public class SectionHtmlJsonProperty
implements JsonProperty {
    private final BdfParameters bdfParameters;
    private final Corpus corpus;
    private final FicheBlocks ficheBlocks;

    public SectionHtmlJsonProperty(BdfParameters bdfParameters, Corpus corpus, FicheBlocks ficheBlocks) {
        this.bdfParameters = bdfParameters;
        this.corpus = corpus;
        this.ficheBlocks = ficheBlocks;
    }

    @Override
    public String getName() {
        return "html";
    }

    @Override
    public void writeValue(JSONWriter jw) throws IOException {
        HashMap<String, Object> formatterOptions = new HashMap<String, Object>();
        formatterOptions.put("externaltarget", "_blank");
        ExtractionContext extractionContext = this.bdfParameters.getDefaultExtractionContext();
        FormatContext formatContext = this.bdfParameters.getBdfServer().getFormatContext();
        FichePointeur pointeur = PointeurFactory.newFichePointeur(this.corpus);
        FicheBlockFormatter ficheBlockFormatter = formatContext.getFicheBlockFormatter(null, formatterOptions);
        FormatSource formatSource = FormatterUtils.toFormatSource(pointeur, extractionContext, null, formatContext);
        String html = ficheBlockFormatter.formatFicheBlocks(this.ficheBlocks, formatSource, this.corpus.getSubsetKey());
        jw.value(html);
    }
}

