/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.impl;

import fr.exemole.bdfserver.api.configuration.LangConfiguration;
import fr.exemole.bdfserver.api.managers.L10nManager;
import fr.exemole.bdfserver.api.managers.UiManager;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.impl.ExtensionManagerImpl;
import fr.exemole.bdfserver.tools.L10nUtils;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.exportation.table.FormatColDefChecker;
import net.fichotheque.exportation.table.TableExportContext;
import net.fichotheque.exportation.table.TableInclusionResolver;
import net.fichotheque.exportation.table.TableInclusionResolverProvider;
import net.fichotheque.format.FichothequeFormatDef;
import net.fichotheque.format.FormatContext;
import net.fichotheque.format.FormatSourceKey;
import net.fichotheque.format.SourceLabelProvider;
import net.fichotheque.format.SubsetPathKey;
import net.fichotheque.format.formatters.SourceFormatter;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.metadata.ThesaurusFieldKey;
import net.fichotheque.tools.exportation.table.inclusionresolvers.AlphabeticInclusionResolver;
import net.fichotheque.tools.exportation.table.inclusionresolvers.ChecksumInclusionResolver;
import net.fichotheque.tools.exportation.table.inclusionresolvers.JsonFicheDistributionInclusionResolver;
import net.fichotheque.tools.exportation.table.inclusionresolvers.MultilangInclusionResolver;
import net.fichotheque.tools.format.FichothequeFormatDefEngine;
import net.fichotheque.utils.TableDefUtils;
import net.mapeadores.util.logging.LineMessageHandler;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.text.Labels;

class TableExportContextImpl
implements TableExportContext {
    private static final AlphabeticInclusionResolver ALPHABETIC_INCLUSIONRESOLVER = new AlphabeticInclusionResolver();
    private static final MultilangInclusionResolver MULTILANG_INCLUSIONRESOLVER = new MultilangInclusionResolver();
    private static final JsonFicheDistributionInclusionResolver JSONFICHEDISTRIBUTION_INCLUSIONRESOLVER = new JsonFicheDistributionInclusionResolver();
    private final SourceLabelProviderImpl sourceLabelProvider = new SourceLabelProviderImpl();
    private final TableInclusionResolverProviderImpl tableInclusionResolverProvider = new TableInclusionResolverProviderImpl();
    private final Fichotheque fichotheque;
    private final ExtensionManagerImpl extensionManager;
    private final FormatContext formatContext;
    private final LangConfiguration langConfiguration;
    private final L10nManager l10nManager;
    private final UiManager uiManager;

    TableExportContextImpl(Fichotheque fichotheque, ExtensionManagerImpl extensionManager, FormatContext formatContext, LangConfiguration langConfiguration, L10nManager l10nManager, UiManager uiManager) {
        this.fichotheque = fichotheque;
        this.extensionManager = extensionManager;
        this.formatContext = formatContext;
        this.langConfiguration = langConfiguration;
        this.l10nManager = l10nManager;
        this.uiManager = uiManager;
    }

    @Override
    public FormatColDefChecker getFormatColDefChecker(Subset subset) {
        return new FormatColDefCheckerImpl(subset);
    }

    @Override
    public FormatContext getFormatContext() {
        return this.formatContext;
    }

    @Override
    public TableInclusionResolverProvider getTableInclusionResolverProvider() {
        return this.tableInclusionResolverProvider;
    }

    @Override
    public SourceLabelProvider getSourceLabelProvider() {
        return this.sourceLabelProvider;
    }

    private class SourceLabelProviderImpl
    implements SourceLabelProvider {
        private SourceLabelProviderImpl() {
        }

        @Override
        public Labels getLabels(Subset subset, FormatSourceKey formatSourceKey) {
            Labels labels = this.innerGetLabels(subset, formatSourceKey);
            if (labels == null) {
                return LabelUtils.EMPTY_LABELS;
            }
            return labels;
        }

        private Labels innerGetLabels(Subset mainSubset, FormatSourceKey formatSourceKey) {
            SubsetKey lastMatchingSubsetKey;
            Subset labelSubset = mainSubset;
            SubsetPathKey subsetPathKey = formatSourceKey.getSubsetPathKey();
            if (subsetPathKey != null && (lastMatchingSubsetKey = subsetPathKey.getMatchingSubsetKey(subsetPathKey.getLength() - 1)) != null && (labelSubset = TableExportContextImpl.this.fichotheque.getSubset(lastMatchingSubsetKey)) == null) {
                return null;
            }
            if (labelSubset instanceof Corpus) {
                return this.getCorpusLabelHolder((Corpus)labelSubset, formatSourceKey);
            }
            if (labelSubset instanceof Thesaurus) {
                return this.getThesaurusLabels((Thesaurus)labelSubset, formatSourceKey);
            }
            return null;
        }

        private Labels getCorpusLabelHolder(Corpus corpus, FormatSourceKey formatSourceKey) {
            switch (formatSourceKey.getSourceType()) {
                case "field": {
                    CorpusField corpusField = corpus.getCorpusMetadata().getCorpusField((FieldKey)formatSourceKey.getKeyObject());
                    if (corpusField == null) {
                        return null;
                    }
                    return corpusField.getLabels();
                }
                case "subsetinclude": {
                    return this.getSubsetIncludeLabels(corpus, (IncludeKey)formatSourceKey.getKeyObject());
                }
                case "id": {
                    return corpus.getCorpusMetadata().getCorpusField(FieldKey.ID).getLabels();
                }
                case "lang": {
                    return corpus.getCorpusMetadata().getCorpusField(FieldKey.LANG).getLabels();
                }
                case "specialinclude": {
                    return this.getSpecialIncludeLabels(corpus, (String)formatSourceKey.getKeyObject());
                }
            }
            return null;
        }

        private Labels getThesaurusLabels(Thesaurus thesaurus, FormatSourceKey formatSourceKey) {
            switch (formatSourceKey.getSourceType()) {
                case "thesaurusfield": {
                    return L10nUtils.toLabels(TableExportContextImpl.this.l10nManager, (ThesaurusFieldKey)formatSourceKey.getKeyObject(), TableExportContextImpl.this.langConfiguration.getWorkingLangs());
                }
                case "subsetinclude": {
                    return this.getDefaultLabels((IncludeKey)formatSourceKey.getKeyObject());
                }
                case "id": {
                    return L10nUtils.toLabels(TableExportContextImpl.this.l10nManager, ThesaurusFieldKey.ID, TableExportContextImpl.this.langConfiguration.getWorkingLangs());
                }
                case "lang": {
                    return L10nUtils.toLabels(TableExportContextImpl.this.l10nManager, ThesaurusFieldKey.BABELIENLANG, TableExportContextImpl.this.langConfiguration.getWorkingLangs());
                }
                case "specialinclude": {
                    return L10nUtils.toLabels(TableExportContextImpl.this.l10nManager, (String)formatSourceKey.getKeyObject(), TableExportContextImpl.this.langConfiguration.getWorkingLangs());
                }
            }
            return null;
        }

        private Labels getSubsetIncludeLabels(Corpus corpus, IncludeKey includeKey) {
            UiComponents uiComponents = TableExportContextImpl.this.uiManager.getMainUiComponents(corpus);
            if (uiComponents == null) {
                return null;
            }
            IncludeUi includeUi = (IncludeUi)uiComponents.getUiComponent(includeKey);
            Labels labels = null;
            if (includeUi != null) {
                labels = includeUi.getCustomLabels();
            }
            if (labels == null) {
                labels = this.getDefaultLabels(includeKey);
            }
            return labels;
        }

        private Labels getSpecialIncludeLabels(Corpus corpus, String specialIncludeName) {
            UiComponents uiComponents = TableExportContextImpl.this.uiManager.getMainUiComponents(corpus);
            if (uiComponents == null) {
                return null;
            }
            IncludeUi includeUi = (IncludeUi)uiComponents.getUiComponent(specialIncludeName);
            Labels labels = null;
            if (includeUi != null) {
                labels = includeUi.getCustomLabels();
            }
            if (labels == null) {
                labels = L10nUtils.toLabels(TableExportContextImpl.this.l10nManager, specialIncludeName, TableExportContextImpl.this.langConfiguration.getWorkingLangs());
            }
            return labels;
        }

        private Labels getDefaultLabels(IncludeKey includeKey) {
            Corpus corpus;
            SubsetKey subsetKey = includeKey.getSubsetKey();
            if (subsetKey.isThesaurusSubset()) {
                Thesaurus thesaurus = (Thesaurus)TableExportContextImpl.this.fichotheque.getSubset(subsetKey);
                if (thesaurus != null) {
                    return thesaurus.getThesaurusMetadata().getTitleLabels();
                }
            } else if (subsetKey.isCorpusSubset() && (corpus = (Corpus)TableExportContextImpl.this.fichotheque.getSubset(subsetKey)) != null) {
                return corpus.getCorpusMetadata().getTitleLabels();
            }
            return null;
        }
    }

    private class TableInclusionResolverProviderImpl
    implements TableInclusionResolverProvider {
        private TableInclusionResolverProviderImpl() {
        }

        @Override
        public TableInclusionResolver getTableInclusionResolver(String inclusionNameSpace) {
            TableInclusionResolver tableInclusionResolver = TableExportContextImpl.this.extensionManager.getExtensionTableInclusionResolver(inclusionNameSpace);
            if (tableInclusionResolver != null) {
                return tableInclusionResolver;
            }
            switch (inclusionNameSpace) {
                case "alphabetic": {
                    return ALPHABETIC_INCLUSIONRESOLVER;
                }
                case "multilang": {
                    return MULTILANG_INCLUSIONRESOLVER;
                }
                case "json_fichedistribution": {
                    return JSONFICHEDISTRIBUTION_INCLUSIONRESOLVER;
                }
                case "md5": {
                    return ChecksumInclusionResolver.MD5_INSTANCE;
                }
                case "sha1": {
                    return ChecksumInclusionResolver.SHA1_INSTANCE;
                }
                case "sha2": {
                    return ChecksumInclusionResolver.SHA2_INSTANCE;
                }
            }
            return null;
        }
    }

    private class FormatColDefCheckerImpl
    implements FormatColDefChecker {
        private final Subset subset;
        private final FichothequeFormatDefEngine.Parameters parameters;

        private FormatColDefCheckerImpl(Subset subset) {
            this.subset = subset;
            this.parameters = FichothequeFormatDefEngine.parameters(TableExportContextImpl.this.formatContext);
        }

        @Override
        public boolean checkFormatColDef(String colName, FichothequeFormatDef formatDef, int lineNumber, LineMessageHandler lineMessageHandler) {
            SourceFormatter formatter = FichothequeFormatDefEngine.compute(this.subset, formatDef, TableDefUtils.toFormatDefMessageHandler(lineMessageHandler, lineNumber), this.parameters);
            return formatter != null;
        }
    }
}

