/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.selection;

import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.selection.DefsHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.selection.FqlEditorHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.selection.FqlXmlHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.selection.SelectFormHtmlProducer;
import net.fichotheque.selection.FichothequeQueries;
import net.fichotheque.tools.selection.FichothequeQueriesBuilder;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public final class SelectionHtmlProducerFactory {
    private SelectionHtmlProducerFactory() {
    }

    public static BdfServerHtmlProducer getHtmlProducer(OutputParameters parameters) throws ErrorMessageException {
        String page = parameters.getOutput();
        RequestMap requestMap = parameters.getRequestMap();
        switch (page) {
            case "defs": {
                return new DefsHtmlProducer(parameters);
            }
            case "selectform": {
                String selectionName = requestMap.getParameter("selectionname");
                return new SelectFormHtmlProducer(parameters, selectionName);
            }
            case "fqleditor": {
                return new FqlEditorHtmlProducer(parameters);
            }
            case "fqlxml": {
                return new FqlXmlHtmlProducer(parameters, SelectionHtmlProducerFactory.getFichothequeQueries(parameters));
            }
        }
        return null;
    }

    private static FichothequeQueries getFichothequeQueries(OutputParameters parameters) {
        return FichothequeQueriesBuilder.init().addFicheQuery(parameters.getBdfUser().getFicheQuery()).toFichothequeQueries();
    }
}

