/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.misc;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.jslib.MiscJsLibs;
import fr.exemole.bdfserver.htmlproducers.corpus.CorpusHtmlUtils;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.JsObject;

public class HistoryHtmlProducer
extends BdfServerHtmlProducer {
    private final Subset subset;
    private final int id;

    public HistoryHtmlProducer(BdfParameters bdfParameters, Subset subset, int id) {
        super(bdfParameters);
        this.subset = subset;
        this.id = id;
        this.addThemeCss("history.css");
        this.addJsLib(MiscJsLibs.HISTORY);
    }

    @Override
    public void printHtml() {
        SubsetKey subsetKey = this.subset.getSubsetKey();
        String clientId = this.generateId();
        JsObject args = JsObject.init().put("clientId", clientId).put("subsetKey", subsetKey.getKeyString()).put("subsetCategory", subsetKey.getCategoryString()).put("subsetName", subsetKey.getSubsetName()).put("id", this.id);
        this.start();
        this.SCRIPT().__jsObject("History.ARGS", args)._SCRIPT().__(this.printHeader()).DIV(HA.id(clientId))._DIV();
        this.end();
    }

    private boolean printHeader() {
        SubsetItem subsetItem = this.subset.getSubsetItemById(this.id);
        if (subsetItem != null) {
            if (subsetItem instanceof FicheMeta) {
                CorpusHtmlUtils.printFicheHeader(this, (FicheMeta)subsetItem, this.workingLang, this.formatLocale);
                return true;
            }
            return false;
        }
        if (this.subset instanceof Corpus) {
            Corpus corpus = (Corpus)this.subset;
            String title = FichothequeUtils.getNumberPhrase(corpus, this.id, "fiche", this.workingLang, this.formatLocale, null);
            SubsetItem masterItem = null;
            Subset masterSubset = corpus.getMasterSubset();
            if (masterSubset != null) {
                masterItem = masterSubset.getSubsetItemById(this.id);
            }
            CorpusHtmlUtils.printFicheHeader(this, title, true, masterItem, this.workingLang, this.formatLocale);
            return true;
        }
        return false;
    }
}

