/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.html.forms;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.users.BdfUser;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.fichotheque.SubsetKey;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.UserLangContext;

public class FormParameters {
    private static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    private final BdfServer bdfServer;
    private final UserLangContext userLangContext;
    private final BdfUser bdfUser;
    private final Map<SubsetKey, Map<String, String>> mapOfMap = new HashMap<SubsetKey, Map<String, String>>();
    private String namePrefix = "";
    private Lang ficheLang = null;
    private String gotoPrefix = "";

    public FormParameters(BdfServer bdfServer, BdfUser bdfUser) {
        this.bdfServer = bdfServer;
        this.bdfUser = bdfUser;
        this.userLangContext = bdfUser;
    }

    public FormParameters(BdfServer bdfServer, UserLangContext userLangContext) {
        this.bdfServer = bdfServer;
        this.bdfUser = null;
        this.userLangContext = userLangContext;
    }

    public FormParameters namePrefix(String namePrefix) {
        if (namePrefix == null) {
            namePrefix = "";
        }
        this.namePrefix = namePrefix;
        return this;
    }

    public String namePrefix() {
        return this.namePrefix;
    }

    public UserLangContext userLangContext() {
        return this.userLangContext;
    }

    public Lang workingLang() {
        return this.userLangContext.getWorkingLang();
    }

    public BdfServer bdfServer() {
        return this.bdfServer;
    }

    public Lang ficheLang() {
        return this.ficheLang;
    }

    public FormParameters ficheLang(Lang ficheLang) {
        this.ficheLang = ficheLang;
        return this;
    }

    public FormParameters gotoPrefix(String gotoPrefix) {
        if (gotoPrefix == null) {
            gotoPrefix = "";
        }
        this.gotoPrefix = gotoPrefix;
        return this;
    }

    public String gotoPrefix() {
        return this.gotoPrefix;
    }

    public Attributes getUserAttributes() {
        if (this.bdfUser != null) {
            return this.bdfUser.getPrefs().getAttributes();
        }
        return AttributeUtils.EMPTY_ATTRIBUTES;
    }

    public Map<String, String> getStoreMap(SubsetKey subsetKey) {
        Map<String, String> map = this.mapOfMap.get(subsetKey);
        if (map == null) {
            map = this.bdfUser != null ? this.bdfServer.getStoredValues(this.bdfUser, "ficheform_" + subsetKey.toString()) : EMPTY_MAP;
            this.mapOfMap.put(subsetKey, map);
        }
        return map;
    }

    public static FormParameters init(BdfServer bdfServer, UserLangContext userLangContext) {
        return new FormParameters(bdfServer, userLangContext);
    }

    public static FormParameters init(BdfParameters bdfParameters) {
        return new FormParameters(bdfParameters.getBdfServer(), bdfParameters.getBdfUser());
    }
}

