/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.html.consumers;

import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.consumers.SubsetIcon;
import java.util.function.Consumer;
import net.fichotheque.Subset;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Label;

public class SubsetTitle
implements Consumer<HtmlPrinter> {
    private final Subset subset;
    private final Lang lang;
    private boolean withSubsetIcon = false;
    private boolean withCategoryPrefix = false;
    private boolean withSubsetName = false;

    public SubsetTitle(Subset subset, Lang lang) {
        this.subset = subset;
        this.lang = lang;
    }

    public SubsetTitle subsetIcon(boolean withSubsetIcon) {
        this.withSubsetIcon = withSubsetIcon;
        return this;
    }

    public SubsetTitle categoryPrefix(boolean with) {
        this.withCategoryPrefix = with;
        return this;
    }

    public SubsetTitle subsetName(boolean withSubsetName) {
        this.withSubsetName = withSubsetName;
        return this;
    }

    @Override
    public void accept(HtmlPrinter hp) {
        short subsetCategory = this.subset.getSubsetKey().getCategory();
        if (this.withSubsetIcon) {
            hp.__(SubsetIcon.getIcon(subsetCategory));
        }
        if (this.withCategoryPrefix) {
            hp.SPAN("subset-Category").__localize(BdfHtmlUtils.getSubsetCategoryLocKey(subsetCategory)).__colon()._SPAN();
        }
        if (this.withSubsetName) {
            Label label = FichothequeUtils.getTitleLabel(this.subset, this.lang);
            if (label != null) {
                hp.SPAN("subset-Title").__escape(label.getLabelString()).__space().SPAN("subset-Key").__escape("[").__escape(this.subset.getSubsetName()).__escape("]")._SPAN()._SPAN();
            } else {
                hp.SPAN("subset-Title").__escape("[").__escape(this.subset.getSubsetName()).__escape("]")._SPAN();
            }
        } else {
            hp.SPAN("subset-Title").__escape(FichothequeUtils.getTitle(this.subset, this.lang))._SPAN();
        }
    }

    public static SubsetTitle init(Subset subset, Lang lang) {
        return new SubsetTitle(subset, lang);
    }
}

