/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.html.consumers;

import java.util.function.Consumer;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;

public final class Common {
    public static final Consumer<HtmlPrinter> REMOVE_CONFIRM_CHECK = Common.confirmationCheck("_ label.global.confirmationcheck_remove");
    public static final Consumer<HtmlPrinter> CLEANING_CONFIRM_CHECK = Common.confirmationCheck("_ label.global.confirmationcheck_cleaning");
    public static final Consumer<HtmlPrinter> MOVE_CONFIRM_CHECK = Common.confirmationCheck("_ label.global.confirmationcheck_move");
    public static final Consumer<HtmlPrinter> MERGE_CONFIRM_CHECK = Common.confirmationCheck("_ label.global.confirmationcheck_merge");
    public static final Consumer<HtmlPrinter> REPLACE_CONFIRM_CHECK = Common.confirmationCheck("_ label.global.confirmationcheck_replace");

    private Common() {
    }

    public static Consumer<HtmlPrinter> escape(String text) {
        return new Escape(text);
    }

    public static Consumer<HtmlPrinter> localize(String key) {
        return new Localize(key);
    }

    public static Consumer<HtmlPrinter> checkboxParagraph(String labelKey, HtmlAttributes choiceAttributes, boolean smaller) {
        return new ChoiceParagraph(labelKey, choiceAttributes.copy().type("checkbox"), smaller);
    }

    public static Consumer<HtmlPrinter> radioParagraph(String labelKey, HtmlAttributes choiceAttributes, boolean smaller) {
        return new ChoiceParagraph(labelKey, choiceAttributes.copy().type("radio"), smaller);
    }

    public static Consumer<HtmlPrinter> confirmationCheck(String labelKey) {
        return Common.checkboxParagraph(labelKey, HA.name("confirmationcheck").value("ok"), true);
    }

    private static class Escape
    implements Consumer<HtmlPrinter> {
        private final String text;

        private Escape(String text) {
            this.text = text;
        }

        @Override
        public void accept(HtmlPrinter hp) {
            hp.__escape(this.text);
        }
    }

    private static class Localize
    implements Consumer<HtmlPrinter> {
        private final String key;

        private Localize(String key) {
            this.key = key;
        }

        @Override
        public void accept(HtmlPrinter hp) {
            hp.__localize(this.key);
        }
    }

    private static class ChoiceParagraph
    implements Consumer<HtmlPrinter> {
        private final String labelKey;
        private final HtmlAttributes choiceAttributes;
        private final boolean smaller;

        private ChoiceParagraph(String labelKey, HtmlAttributes choiceAttributes, boolean smaller) {
            this.labelKey = labelKey;
            this.choiceAttributes = choiceAttributes;
            this.smaller = smaller;
        }

        @Override
        public void accept(HtmlPrinter hp) {
            String id = hp.generateId();
            hp.P(this.smaller ? "command-FlexInput command-Smaller" : "command-FlexInput").INPUT(this.choiceAttributes.copy().id(id)).LABEL_for(id).__localize(this.labelKey)._LABEL()._P();
        }
    }
}

