/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.html;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.namespaces.BdfSessionSpace;
import fr.exemole.bdfserver.api.session.AuthenticationException;
import fr.exemole.bdfserver.api.session.LoginParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.Grid;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import fr.exemole.bdfserver.tools.subsettree.TreeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.fichotheque.SubsetKey;
import net.fichotheque.metadata.FichothequeMetadata;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.utils.FichothequeMetadataUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.html.ConsumerFactory;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.localisation.LangPreference;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.Phrase;

public class LoginHtmlProducer
extends BdfServerHtmlProducer {
    private static final Consumer<HtmlPrinter> LOGIN_SUBMIT = Button.submit("_ submit.session.login");
    private static final Consumer<HtmlPrinter> LOGIN_ICON = ConsumerFactory.emptySpan("global-button-Icon login-Icon");
    private final LoginParameters loginParameters;
    private final String reversePath;

    public LoginHtmlProducer(BdfServer bdfServer, LangPreference langPreference, LoginParameters loginParameters) {
        super(bdfServer, langPreference);
        this.setWithJavascript(true);
        this.loginParameters = loginParameters;
        this.reversePath = loginParameters.getReversePath();
        this.scanIcons();
        this.setReversePath(this.reversePath);
        this.addThemeCss("login.css");
        this.setBodyCssClass("global-body-Transparent");
    }

    @Override
    public void printHtml() {
        String title = this.getTitle();
        this.start(title);
        this.__(this.printLogo()).H1("login-Title").__escape(title)._H1();
        this.P("login-Text login-Subtitle").__(this.printSubtitleMessage())._P();
        this.DIV("login-Block").__(PageUnit.start("_ title.session.loginfieldset").sectionCss("unit-Unit login-Unit").icon(LOGIN_ICON)).FORM_post(this.loginParameters.getFormAction()).__(Grid.START).__(this.printSphereRow()).__(Grid.textInputRow("_ label.session.login", this.name("bdf-login").value(this.getDefaultValue("bdf-login", "bdf-default-login")).classes("login-Input"))).__(Grid.passwordInputRow("_ label.session.password", this.name("bdf-password").classes("login-Input"))).__(Grid.END).NOSCRIPT().INPUT_hidden("bdf-noscript", "1")._NOSCRIPT().DIV("login-Text").__(LOGIN_SUBMIT)._DIV().__(this.printCurrentParameters())._FORM().__(this.printAuthenticationException()).__(PageUnit.END)._DIV();
        this.end();
    }

    private boolean printLogo() {
        if (!this.bdfServer.getResourceStorages().containsResource(StorageUtils.LOGO)) {
            return false;
        }
        this.IMG(HA.src(this.reversePath + StorageUtils.LOGO.toString()).alt("logo").classes("login-Logo"));
        return true;
    }

    private boolean printSubtitleMessage() {
        CommandMessage commandMessage = this.loginParameters.getCommandMessage();
        if (commandMessage != null) {
            this.__localize(commandMessage);
        } else {
            this.__localize("_ info.session.newsession");
        }
        return true;
    }

    private boolean printSphereRow() {
        List<Sphere> sphereList;
        int size;
        SubsetKey defaultSphereKey;
        String defaultValue = this.getDefaultValue("bdf-sphere", "bdf-default-sphere");
        if (defaultValue.isEmpty() && (defaultSphereKey = this.loginParameters.getDefaultSphereKey()) != null) {
            defaultValue = defaultSphereKey.getSubsetName();
        }
        if ((size = (sphereList = this.checkSphereList()).size()) == 0) {
            return false;
        }
        if (size == 1) {
            String sphereName = sphereList.get(0).getSubsetName();
            if (!BdfSessionSpace.showUniqueRow(this.fichotheque)) {
                this.INPUT_hidden("bdf-sphere", sphereName);
                return true;
            }
            defaultValue = sphereName;
        }
        String currentSphereName = defaultValue;
        this.__(Grid.selectRow((Object)"_ label.session.sphere", this.name("bdf-sphere"), () -> {
            for (Sphere sphere : sphereList) {
                String name = sphere.getSubsetName();
                this.OPTION(name, name.equals(currentSphereName)).__escape(FichothequeUtils.getTitleWithKey(sphere, this.workingLang))._OPTION();
            }
        }));
        return true;
    }

    private String getDefaultValue(String paramName, String defaultParamName) {
        RequestMap requestMap = this.loginParameters.getRequestMap();
        String defaultValue = requestMap.getParameter(paramName);
        if (defaultValue == null) {
            defaultValue = requestMap.getParameter(defaultParamName);
        }
        defaultValue = defaultValue == null ? "" : defaultValue.trim();
        return defaultValue;
    }

    private boolean printAuthenticationException() {
        AuthenticationException authenticationException = this.loginParameters.getAuthenticationException();
        if (authenticationException == null) {
            return false;
        }
        String errorMessageKey = authenticationException.getErrorMessageKey();
        if (!errorMessageKey.equals(AuthenticationException.UNDEFINED_ERROR) && !errorMessageKey.equals(AuthenticationException.EXIT_ERROR)) {
            this.P("login-Text login-Warning").__localize(errorMessageKey)._P();
            return true;
        }
        return false;
    }

    private boolean printCurrentParameters() {
        RequestMap bdfRequestMap = this.loginParameters.getRequestMap();
        if (bdfRequestMap == null) {
            return false;
        }
        Set<String> paramNameSet = bdfRequestMap.getParameterNameSet();
        HtmlAttributes hiddenAttr = HA.type("hidden");
        for (String paramName : paramNameSet) {
            String[] paramValues;
            if (paramName.startsWith("bdf-") || (paramValues = bdfRequestMap.getParameterValues(paramName)) == null) continue;
            int length = paramValues.length;
            if (length == 1) {
                this.INPUT(hiddenAttr.name(paramName).value(paramValues[0]), true);
                continue;
            }
            for (int i = 0; i < length; ++i) {
                this.INPUT(hiddenAttr.name(paramName).value(paramValues[i]), false);
            }
        }
        return true;
    }

    private List<Sphere> checkSphereList() {
        ArrayList<Sphere> result = new ArrayList<Sphere>();
        List<SubsetKey> customSphereKeyList = this.loginParameters.getLoginSphrereKeyList();
        if (customSphereKeyList != null) {
            for (SubsetKey sphereKey : customSphereKeyList) {
                Sphere sphere = (Sphere)this.fichotheque.getSubset(sphereKey);
                if (sphere == null) continue;
                result.add(sphere);
            }
            if (!result.isEmpty()) {
                return result;
            }
        }
        List<SubsetKey> sphereKeyList = TreeUtils.toList(this.bdfServer.getTreeManager().getSubsetTree((short)3));
        for (SubsetKey sphereKey : sphereKeyList) {
            Sphere sphere = (Sphere)this.fichotheque.getSubset(sphereKey);
            if (sphere == null || BdfSessionSpace.isHiddenAtLogin(sphere)) continue;
            result.add(sphere);
        }
        return result;
    }

    private String getTitle() {
        Label label;
        Phrase fichothequePhrase;
        FichothequeMetadata fichothequeMetadata = this.bdfServer.getFichotheque().getFichothequeMetadata();
        String phraseName = this.loginParameters.getTitlePhraseName();
        if (phraseName != null && (fichothequePhrase = fichothequeMetadata.getPhrases().getPhrase(phraseName)) != null && (label = fichothequePhrase.getLangPartCheckedLabel(this.workingLang)) != null) {
            return label.getLabelString();
        }
        return FichothequeMetadataUtils.getLongTitle(this.bdfServer.getFichotheque(), this.workingLang);
    }
}

