/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.get.instructions.tables;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.managers.TableExportManager;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.get.streamproducers.TableExportCsvProducer;
import fr.exemole.bdfserver.get.streamproducers.TableExportHtmlProducer;
import fr.exemole.bdfserver.get.streamproducers.TableExportOdsProducer;
import fr.exemole.bdfserver.tools.exportation.table.BdfTableExportUtils;
import fr.exemole.bdfserver.tools.exportation.table.CellConversionInit;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.exportation.table.SubsetTable;
import net.fichotheque.exportation.table.SumCellConverter;
import net.fichotheque.exportation.table.TableExport;
import net.fichotheque.exportation.table.TableExportConstants;
import net.fichotheque.exportation.table.TableExportContext;
import net.fichotheque.exportation.table.TableExportDef;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.exportation.table.TableExportOdsParameters;
import net.fichotheque.utils.CorpusUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.HtmlResponseHandler;
import net.mapeadores.util.servlets.handlers.StreamResponseHandler;
import net.mapeadores.util.text.FileName;
import net.mapeadores.util.text.StringUtils;

public class UniqueTableExportEngine {
    public static final String ECHANTILLON_TYPE = "echantillon";
    public static final String SELECTION_TYPE = "selection";
    private static final String SUBSET_PARAMNAME = "subset";
    private static final String TYPE_PARAMNAME = "type";
    private static final String TABLEEXPORT_PARAMNAME = "tableexport";
    private static final String HEADER_PARAMNAME = "header";
    private final BdfParameters bdfParameters;
    private final BdfServer bdfServer;
    private String type = "selection";
    private String headerType = "columntitle";
    private final SubsetKey subsetKey;
    private String tableExportName;
    private final String extension;
    private boolean fragment;

    private UniqueTableExportEngine(BdfParameters bdfParameters, SubsetKey subsetKey, String extension) {
        this.bdfParameters = bdfParameters;
        this.bdfServer = bdfParameters.getBdfServer();
        this.subsetKey = subsetKey;
        this.extension = extension;
    }

    private void setTableExportName(String tableExportName) {
        this.tableExportName = tableExportName;
    }

    private void setType(String type) {
        this.type = type;
    }

    private void setHeaderType(String headerType) {
        this.headerType = headerType;
    }

    private void setFragment(boolean fragment) {
        this.fragment = fragment;
    }

    public ResponseHandler run() {
        PermissionSummary permissionSummary = this.bdfParameters.getPermissionSummary();
        TableExportManager tableExportManager = this.bdfServer.getTableExportManager();
        SubsetTable subsetTable = null;
        TableExportDef tableExportDef = null;
        if (this.tableExportName != null) {
            TableExport tableExport = tableExportManager.getTableExport(this.tableExportName);
            if (tableExport != null) {
                tableExportDef = tableExport.getTableExportDef();
                subsetTable = tableExport.getSubsetTable(this.subsetKey);
            }
        } else {
            Subset subset = this.bdfServer.getFichotheque().getSubset(this.subsetKey);
            if (subset != null) {
                subsetTable = BdfTableExportUtils.toDefaultSubsetTable(this.bdfServer, subset, this.bdfParameters.getBdfUser().getPrefs().getDefaultFicheTableParameters(), permissionSummary);
            }
        }
        if (subsetTable == null) {
            return null;
        }
        if (!permissionSummary.hasAccess(subsetTable.getSubset())) {
            return null;
        }
        TableExportContext tableExportContext = this.bdfServer.getTableExportContext();
        Collection<SubsetItem> subsetItems = this.getSubsetItems();
        ExtractionContext extractionContext = this.bdfParameters.getDefaultExtractionContext();
        SumCellConverter sumCellConverter = CellConversionInit.subsetTable(this.bdfServer, extractionContext, subsetTable, tableExportDef).getCellConverter();
        switch (this.extension) {
            case "csv": {
                return StreamResponseHandler.init(new TableExportCsvProducer(null, this.bdfParameters, subsetTable, subsetItems, this.headerType, tableExportContext, sumCellConverter));
            }
            case "ods": {
                return StreamResponseHandler.init(TableExportOdsProducer.newUniqueInstance(null, this.bdfParameters, subsetTable, subsetItems, TableExportOdsParameters.init(tableExportContext, this.bdfParameters.getUserLangContext()).setSumCellConverter(sumCellConverter).setHeaderType(this.headerType)));
            }
        }
        return HtmlResponseHandler.init(new TableExportHtmlProducer(this.bdfParameters, subsetTable, subsetItems, this.headerType, this.fragment, tableExportContext, sumCellConverter));
    }

    public static UniqueTableExportEngine buildFromRequest(BdfParameters bdfParameters, RequestMap requestMap) throws ErrorMessageException {
        String subsetString = requestMap.getParameter(SUBSET_PARAMNAME);
        if (subsetString == null) {
            throw BdfErrors.emptyMandatoryParameter(SUBSET_PARAMNAME);
        }
        SubsetKey subsetKey = UniqueTableExportEngine.parseSubsetKey(SUBSET_PARAMNAME, subsetString);
        UniqueTableExportEngine tableExportEngine = new UniqueTableExportEngine(bdfParameters, subsetKey, "html");
        String tableexportString = requestMap.getParameter(TABLEEXPORT_PARAMNAME);
        if (tableexportString != null) {
            tableExportEngine.setTableExportName(UniqueTableExportEngine.testTableExport(bdfParameters.getBdfServer(), TABLEEXPORT_PARAMNAME, tableexportString));
        }
        UniqueTableExportEngine.initCommonParam(tableExportEngine, requestMap, bdfParameters.getBdfUser());
        tableExportEngine.setFragment(true);
        return tableExportEngine;
    }

    public static UniqueTableExportEngine buildFromPath(BdfParameters bdfParameters, FileName fileName, RequestMap requestMap) throws ErrorMessageException {
        String[] tokens = StringUtils.getTokens(fileName.getBasename(), '-', (short)2);
        int length = tokens.length;
        SubsetKey subsetKey = UniqueTableExportEngine.parseSubsetKey("tables instruction", tokens[0]);
        String extension = fileName.getExtension();
        if (!UniqueTableExportEngine.testExtension(extension)) {
            throw new ErrorMessageException("_ error.unknown.extension", extension);
        }
        UniqueTableExportEngine tableExportEngine = new UniqueTableExportEngine(bdfParameters, subsetKey, extension);
        if (length > 1) {
            String value = tokens[1];
            tableExportEngine.setTableExportName(UniqueTableExportEngine.testTableExport(bdfParameters.getBdfServer(), "-", value));
        }
        UniqueTableExportEngine.initCommonParam(tableExportEngine, requestMap, bdfParameters.getBdfUser());
        return tableExportEngine;
    }

    private static void initCommonParam(UniqueTableExportEngine tableExportEngine, RequestMap requestMap, BdfUser bdfUser) throws ErrorMessageException {
        String headerType;
        String typeString = requestMap.getTrimedParameter(TYPE_PARAMNAME);
        if (!typeString.isEmpty()) {
            switch (typeString) {
                case "echantillon": 
                case "selection": {
                    tableExportEngine.setType(typeString);
                    break;
                }
                default: {
                    throw BdfErrors.unknownParameterValue(TYPE_PARAMNAME, typeString);
                }
            }
        }
        if (!(headerType = requestMap.getTrimedParameter(HEADER_PARAMNAME)).isEmpty()) {
            try {
                tableExportEngine.setHeaderType(TableExportConstants.checkHeaderType(headerType));
            }
            catch (IllegalArgumentException iae) {
                throw BdfErrors.unknownParameterValue(HEADER_PARAMNAME, headerType);
            }
        } else {
            tableExportEngine.setHeaderType(bdfUser.getPrefs().getDefaultHeaderType());
        }
    }

    private Collection<SubsetItem> getSubsetItems() {
        if (this.subsetKey.isCorpusSubset()) {
            Fiches fiches = this.bdfParameters.getBdfUser().getSelectedFiches();
            List<SubsetItem> ficheMetaList = CorpusUtils.getFicheMetaListByCorpus(fiches, this.subsetKey);
            if (this.type.equals(SELECTION_TYPE)) {
                return ficheMetaList;
            }
            if (this.type.equals(ECHANTILLON_TYPE)) {
                if (ficheMetaList.size() > 0) {
                    return UniqueTableExportEngine.reduceList(ficheMetaList);
                }
                Corpus corpus = (Corpus)this.bdfServer.getFichotheque().getSubset(this.subsetKey);
                if (corpus == null) {
                    return FichothequeUtils.EMPTY_SUBSETITEMLIST;
                }
                return UniqueTableExportEngine.reduceList(corpus.getSubsetItemList());
            }
            throw new SwitchException("Unknown prefix: " + this.type);
        }
        if (this.subsetKey.isThesaurusSubset()) {
            Thesaurus thesaurus = (Thesaurus)this.bdfServer.getFichotheque().getSubset(this.subsetKey);
            if (thesaurus == null || thesaurus.size() == 0) {
                return FichothequeUtils.EMPTY_SUBSETITEMLIST;
            }
            int max = -1;
            if (this.type.equals(ECHANTILLON_TYPE)) {
                max = 5;
            }
            return ThesaurusUtils.toSubsetItemList(thesaurus, max);
        }
        throw new SwitchException("Unknown subset: " + this.subsetKey);
    }

    private static String testTableExport(BdfServer bdfServer, String paramName, String paramValue) throws ErrorMessageException {
        if (paramValue.length() == 0) {
            return null;
        }
        TableExportManager tableExportManager = bdfServer.getTableExportManager();
        if (!tableExportManager.containsTableExport(paramValue)) {
            throw new ErrorMessageException("_ error.unknown.parametervalue", paramName, paramValue);
        }
        return paramValue;
    }

    private static SubsetKey parseSubsetKey(String paramName, String paramValue) throws ErrorMessageException {
        SubsetKey subsetKey;
        try {
            subsetKey = SubsetKey.parse(paramValue);
        }
        catch (ParseException pe) {
            throw new ErrorMessageException("_ error.wrong.parametervalue", paramName, paramValue);
        }
        if (!subsetKey.isCorpusSubset() && !subsetKey.isThesaurusSubset()) {
            throw new ErrorMessageException("_ error.wrong.parametervalue", paramName, paramValue);
        }
        return subsetKey;
    }

    private static boolean testExtension(String extension) {
        switch (extension) {
            case "html": 
            case "csv": 
            case "ods": {
                return true;
            }
        }
        return false;
    }

    private static List<SubsetItem> reduceList(List<SubsetItem> origin) {
        if (origin.size() <= 3) {
            return origin;
        }
        ArrayList<SubsetItem> result = new ArrayList<SubsetItem>();
        result.add(origin.get(0));
        result.add(origin.get(1));
        result.add(origin.get(2));
        return result;
    }
}

