/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.thesaurus.ThesaurusTools;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class MotcleMoveCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "MotcleMove";
    public static final String COMMANDKEY = "_ THS-17";
    public static String DESTINATIONTHESAURUS_PARAMNAME = "destinationthesaurus";
    private Motcle motcle;
    private Thesaurus destinationThesaurus;

    public MotcleMoveCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        Motcle newMotcle;
        Lang lang = this.bdfUser.getWorkingLang();
        Langs langs = this.bdfServer.getThesaurusLangChecker().getAuthorizedLangs(this.destinationThesaurus);
        try (EditSession session = this.startEditSession("thesaurus", COMMANDNAME);){
            newMotcle = ThesaurusTools.move(session.getFichothequeEditor(), this.motcle, this.destinationThesaurus, langs);
        }
        this.bdfUser.putParameter("bdf.thesaurus.move_last", this.destinationThesaurus.getSubsetKey());
        this.putResultObject("obj.thesaurus", this.destinationThesaurus);
        this.putResultObject("obj.motcle", newMotcle);
        this.setDone("_ done.thesaurus.motclemove", ThesaurusUtils.getMotcleTitle(this.motcle, lang, true, false), FichothequeUtils.getTitle(this.destinationThesaurus, lang), newMotcle.getId(), true);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.motcle = this.requestHandler.getMandatoryMotcle();
        this.checkSubsetAdmin(this.motcle.getThesaurus());
        if (!this.checkConfirmation()) {
            throw BdfErrors.error("_ error.empty.confirmationcheck_move");
        }
        String destinationThesaurusName = this.getMandatory(DESTINATIONTHESAURUS_PARAMNAME);
        this.destinationThesaurus = this.fichotheque.getThesaurus(destinationThesaurusName);
        if (this.destinationThesaurus == null) {
            throw BdfErrors.error("_ error.unknown.thesaurus", destinationThesaurusName);
        }
        this.checkSubsetAdmin(this.destinationThesaurus);
        if (this.destinationThesaurus.equals(this.motcle.getThesaurus())) {
            throw BdfErrors.error("_ error.unsupported.samethesaurus");
        }
    }
}

