/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeParser;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class MotcleAttributeChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "MotcleAttributeChange";
    public static final String COMMANDKEY = "_ THS-20";
    public static final String ATTRIBUTES_PARAMNAME = "attributes";
    private Motcle motcle;
    private AttributeChange attributeChange;

    public MotcleAttributeChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("thesaurus", COMMANDNAME);){
            session.getFichothequeEditor().changeAttributes(this.motcle, this.attributeChange);
        }
        this.putResultObject("obj.thesaurus", this.motcle.getThesaurus());
        this.putResultObject("obj.motcle", this.motcle);
        this.setDone("_ done.global.attributechange", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.motcle = this.requestHandler.getMandatoryMotcle();
        this.checkSubsetAdmin(this.motcle.getThesaurus());
        String attributes = this.getMandatory(ATTRIBUTES_PARAMNAME);
        this.attributeChange = AttributeParser.parse(attributes);
    }
}

