/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.tools.thesaurus.IdalphaSortEngine;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class IdalphaSortCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "IdalphaSort";
    public static final String COMMANDKEY = "_ THS-07";
    public static final String RECURSIVE_PARAMNAME = "recursive";
    public static final String DESCENDING_PARAMNAME = "descending";
    public static final String IGNORECASE_PARAMNAME = "ignorecase";
    public static final String IGNOREPUNCTUATION_PARAMNAME = "ignorepunctuation";
    private Thesaurus thesaurus;
    private Motcle motcle;
    private boolean recursive = false;
    private boolean descending = false;
    private boolean ignoreCase = false;
    private boolean ignorePunctuation = false;

    public IdalphaSortCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("thesaurus", COMMANDNAME);){
            ThesaurusEditor thesaurusEditor = session.getFichothequeEditor().getThesaurusEditor(this.thesaurus);
            IdalphaSortEngine.init(thesaurusEditor).setRecursive(this.recursive).setDescending(this.descending).setIgnoreCase(this.ignoreCase).setIgnorePunctuation(this.ignorePunctuation).sort(this.motcle);
        }
        this.putResultObject("obj.thesaurus", this.thesaurus);
        if (this.motcle != null) {
            this.putResultObject("obj.motcle", this.motcle);
        }
        this.setDone("_ done.thesaurus.idalphasort", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.thesaurus = this.requestHandler.getMandatoryThesaurus();
        this.checkSubsetAdmin(this.thesaurus);
        this.motcle = this.requestHandler.getOptionnalMotcle(this.thesaurus);
        this.recursive = this.requestHandler.isTrue(RECURSIVE_PARAMNAME);
        this.descending = this.requestHandler.isTrue(DESCENDING_PARAMNAME);
        this.ignoreCase = this.requestHandler.isTrue(IGNORECASE_PARAMNAME);
        this.ignorePunctuation = this.requestHandler.isTrue(IGNOREPUNCTUATION_PARAMNAME);
    }
}

