/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.selection;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.tools.selection.FichothequeQueriesBuilder;
import net.fichotheque.tools.selection.SelectionDOMUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class FqlParserCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "FqlParser";
    public static final String XML_PARAMNAME = "xml";
    private String xml;

    public FqlParserCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return false;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        String xmlContent = this.checkXML();
        FichothequeQueriesBuilder fichothequeQueriesBuilder = new FichothequeQueriesBuilder();
        try {
            Document document = DOMUtils.parseDocument(xmlContent);
            DOMUtils.readChildren(document.getDocumentElement(), SelectionDOMUtils.getQueryElementConsumer(this.fichotheque, fichothequeQueriesBuilder));
        }
        catch (SAXException saxException) {
            throw BdfErrors.error("_ error.exception.xml.sax", saxException.getMessage());
        }
        this.putResultObject("obj.fichothequequeries", fichothequeQueriesBuilder.toFichothequeQueries());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.xml = this.getMandatory(XML_PARAMNAME);
    }

    private String checkXML() {
        int idx = this.xml.indexOf("<fql");
        if (idx == -1) {
            idx = this.xml.indexOf("<queries");
        }
        if (idx == -1) {
            return "<fql>" + this.xml + "</fql>";
        }
        return this.xml;
    }
}

