/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.album.Album;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.tools.conversion.imagetoillustration.ImageToIllustrationConverter;
import net.mapeadores.util.logging.CommandMessageBuilder;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.SourceLogsBuilder;
import net.mapeadores.util.request.RequestMap;

public class ImageToIllustrationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "ImageToIllustration";
    public static final String COMMANDKEY = "_ CRP-26";
    public static final String FIELD_PARAMNAME = "field";
    public static final String ALBUMINCLUDE_PARAMNAME = "albuminclude";
    public static final String BASEURL_PARAMNAME = "baseurl";
    public static final String MODE_PARAMNAME = "mode";
    public static final String RUN_MODE_PARAMVALUE = "run";
    public static final String TEST_MODE_PARAMVALUE = "test";
    private Corpus corpus;
    private Album album;
    private CorpusField sourceField;
    private IncludeKey albumIncludeKey;
    private String baseUrl;
    private boolean testOnly;

    public ImageToIllustrationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        SourceLogsBuilder logsBuilder = new SourceLogsBuilder();
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            FichothequeEditor fichothequeEditor = session.getFichothequeEditor();
            ImageToIllustrationConverter imageToIllustrationConverter = new ImageToIllustrationConverter(fichothequeEditor.getAlbumEditor(this.album), fichothequeEditor.getJunctionEditor(), logsBuilder, this.testOnly);
            for (FicheMeta ficheMeta : this.corpus.getFicheMetaList()) {
                imageToIllustrationConverter.convert(ficheMeta, this.sourceField.getFieldKey(), this.baseUrl, this.albumIncludeKey.getMode(), this.albumIncludeKey.getWeightFilter());
            }
        }
        String messageKey = this.testOnly ? "_ done.corpus.imagetoillustration_test" : "_ done.corpus.imagetoillustration_run";
        this.setCommandMessage(CommandMessageBuilder.init().setCommandLogs(logsBuilder.toSourceLogs()).setDone(messageKey, new Object[0]).toCommandMessage());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        String modeString;
        String value;
        this.checkFichothequeAdmin();
        this.corpus = this.requestHandler.getMandatoryCorpus();
        this.baseUrl = this.getMandatory(BASEURL_PARAMNAME).trim();
        String fieldParamName = this.getMandatory(FIELD_PARAMNAME);
        try {
            FieldKey fieldKey = FieldKey.parse(fieldParamName);
            this.sourceField = this.corpus.getCorpusMetadata().getCorpusField(fieldKey);
            if (this.sourceField == null) {
                throw BdfErrors.unknownParameterValue(FIELD_PARAMNAME, fieldParamName);
            }
        }
        catch (ParseException pe) {
            throw BdfErrors.wrongParameterValue(FIELD_PARAMNAME, fieldParamName);
        }
        switch (this.sourceField.getFicheItemType()) {
            case "item": 
            case "image": {
                break;
            }
            default: {
                throw BdfErrors.error("_ error.unsupported.ficheitemtype", fieldParamName);
            }
        }
        if (this.baseUrl.isEmpty() && this.sourceField.isType("image") && (value = this.sourceField.getStringOption("baseUrl")) != null) {
            this.baseUrl = value;
        }
        this.testOnly = !(modeString = this.getMandatory(MODE_PARAMNAME)).equals(RUN_MODE_PARAMVALUE);
        String albumIncludeKeyString = this.getMandatory(ALBUMINCLUDE_PARAMNAME);
        try {
            this.albumIncludeKey = IncludeKey.parse(albumIncludeKeyString);
        }
        catch (ParseException pe) {
            throw BdfErrors.error("_ error.wrong.includekey", albumIncludeKeyString);
        }
        if (!this.albumIncludeKey.getSubsetKey().isAlbumSubset()) {
            throw BdfErrors.error("_ error.unsupported.subsetcategory", albumIncludeKeyString);
        }
        this.album = (Album)this.fichotheque.getSubset(this.albumIncludeKey.getSubsetKey());
        if (this.album == null) {
            throw BdfErrors.error("_ error.unknown.album", albumIncludeKeyString);
        }
    }
}

