/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.configuration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.groups.GroupDef;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class GroupRemoveCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "GroupRemove";
    public static final String COMMANDKEY = "_ CNF-12";
    public static final String NAME_PARAMNAME = "name";
    private GroupDef groupDef;

    public GroupRemoveCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        String name = this.groupDef.getName();
        try (EditSession session = this.startEditSession("configuration", COMMANDNAME);){
            session.getBdfServerEditor().removeGroupDef(this.groupDef);
        }
        this.setDone("_ done.configuration.groupremove", name);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        String name = this.getMandatory(NAME_PARAMNAME);
        this.groupDef = this.bdfServer.getGroupManager().getGroupDef(name);
        if (this.groupDef == null) {
            throw BdfErrors.unknownParameterValue(NAME_PARAMNAME, name);
        }
        if (!this.checkConfirmation()) {
            throw BdfErrors.error("_ error.empty.confirmationcheck_remove");
        }
    }
}

