/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.configuration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.BdfServerEditor;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.groups.GroupDef;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeParser;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.LabelChange;
import net.mapeadores.util.text.StringUtils;

public class GroupCreationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "GroupCreation";
    public static final String COMMANDKEY = "_ CNF-10";
    public static final String NAME_PARAMNAME = "name";
    public static final String TITLE_PARAMPREFIX = "title/";
    public static final String ATTRIBUTES_PARAMNAME = "attributes";
    private String name;
    private LabelChange groupLabelChange;
    private AttributeChange attributeChange;

    public GroupCreationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("configuration", COMMANDNAME);){
            BdfServerEditor bdfServerEditor = session.getBdfServerEditor();
            GroupDef groupDef = bdfServerEditor.createGroupDef(this.name);
            BdfServerUtils.changeLabels(bdfServerEditor, groupDef, this.groupLabelChange);
            if (this.attributeChange != null) {
                BdfServerUtils.changeAttributes(bdfServerEditor, groupDef, this.attributeChange);
            }
        }
        this.setDone("_ done.configuration.groupcreation", this.name);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.name = this.getMandatory(NAME_PARAMNAME);
        if (!StringUtils.isTechnicalName(this.name, true)) {
            throw BdfErrors.error("_ error.wrong.groupname", this.name);
        }
        if (this.bdfServer.getGroupManager().getGroupDef(this.name) != null) {
            throw BdfErrors.error("_ error.existing.group", this.name);
        }
        this.groupLabelChange = this.requestHandler.getLabelChange(TITLE_PARAMPREFIX);
        String attributes = this.requestHandler.getTrimedParameter(ATTRIBUTES_PARAMNAME);
        if (!attributes.isEmpty()) {
            this.attributeChange = AttributeParser.parse(attributes);
        }
    }
}

