/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.configuration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.BdfServerEditor;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.groups.GroupDef;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeParser;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.LabelChange;

public class GroupChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "GroupChange";
    public static final String COMMANDKEY = "_ CNF-11";
    public static final String NAME_PARAMNAME = "name";
    public static final String TITLE_PARAMPREFIX = "title/";
    public static final String ATTRIBUTES_PARAMNAME = "attributes";
    private GroupDef groupDef;
    private LabelChange groupLabelChange;
    private AttributeChange attributeChange;

    public GroupChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("configuration", COMMANDNAME);){
            BdfServerEditor bdfServerEditor = session.getBdfServerEditor();
            BdfServerUtils.changeLabels(bdfServerEditor, this.groupDef, this.groupLabelChange);
            if (this.attributeChange != null) {
                BdfServerUtils.changeAttributes(bdfServerEditor, this.groupDef, this.attributeChange);
            }
        }
        this.setDone("_ done.configuration.groupchange", this.groupDef.getName());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        String name = this.getMandatory(NAME_PARAMNAME);
        this.groupDef = this.bdfServer.getGroupManager().getGroupDef(name);
        if (this.groupDef == null) {
            throw BdfErrors.unknownParameterValue(NAME_PARAMNAME, name);
        }
        this.groupLabelChange = this.requestHandler.getLabelChange(TITLE_PARAMPREFIX);
        String attributes = this.requestHandler.getTrimedParameter(ATTRIBUTES_PARAMNAME);
        if (!attributes.isEmpty()) {
            this.attributeChange = AttributeParser.parse(attributes);
        }
    }
}

