/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.album;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.ExistingSubsetException;
import net.fichotheque.SubsetKey;
import net.fichotheque.album.Album;
import net.fichotheque.album.AlbumEditor;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class AlbumCreationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "AlbumCreation";
    public static final String COMMANDKEY = "_ ALB-01";
    public static final String NEWALBUM_PARAMNAME = "newalbum";
    private SubsetKey newSubsetKey;

    public AlbumCreationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        Album album;
        try (EditSession session = this.startEditSession("album", COMMANDNAME);){
            try {
                AlbumEditor albumEditor = session.getFichothequeEditor().createAlbum(this.newSubsetKey);
                album = albumEditor.getAlbum();
            }
            catch (ExistingSubsetException ese) {
                throw new ShouldNotOccurException("test done before", ese);
            }
        }
        this.putResultObject("obj.album", album);
        this.setDone("_ done.album.albumcreation", this.newSubsetKey.getKeyString());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        String newAlbumName = this.getMandatory(NEWALBUM_PARAMNAME);
        newAlbumName = newAlbumName.trim();
        if (newAlbumName.length() == 0) {
            throw BdfErrors.error("_ error.empty.albumname");
        }
        try {
            this.newSubsetKey = SubsetKey.parse((short)5, newAlbumName);
        }
        catch (ParseException pe) {
            throw BdfErrors.error("_ error.wrong.albumname", newAlbumName);
        }
        if (this.fichotheque.containsSubset(this.newSubsetKey)) {
            throw BdfErrors.error("_ error.existing.album", newAlbumName);
        }
    }
}

