/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.administration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import java.io.IOException;
import java.io.InputStream;
import net.fichotheque.EditOrigin;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.FileValue;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.RelativePath;

public class ResourceUploadCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "ResourceUpload";
    public static final String LOGO_COMMANDKEY = "_ CNF-06";
    public static final String ICON16_COMMANDKEY = "_ CNF-07";
    public static final String ICON32_COMMANDKEY = "_ CNF-08";
    public static final String FILE_PARAMNAME = "file";
    private RelativePath relativePath;

    public ResourceUploadCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        FileValue fileValue = this.requestHandler.getRequestMap().getFileValue(FILE_PARAMNAME);
        if (fileValue == null) {
            throw BdfErrors.emptyMandatoryParameter(FILE_PARAMNAME);
        }
        boolean done = false;
        if (fileValue.length() > 0L) {
            EditOrigin editOrigin = this.bdfUser.newEditOrigin("administration", COMMANDNAME);
            try (InputStream is = fileValue.getInputStream();){
                StorageUtils.saveResource(this.bdfServer, this.relativePath, is, editOrigin);
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            done = true;
        }
        fileValue.free();
        if (done) {
            this.putResultObject("obj.relativepath", this.relativePath);
            this.setDone("_ done.administration.resourceupload", new Object[0]);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.relativePath = this.requestHandler.getMandatoryRelativePath();
    }
}

