/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.administration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.tools.configuration.ConfigurationUtils;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.zip.BackupZip;
import fr.exemole.bdfserver.tools.zip.BdfServerZip;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipOutputStream;
import net.fichotheque.eligibility.SubsetEligibility;
import net.fichotheque.tools.eligibility.SelectionSubsetEligibility;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class BackupCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "Backup";
    public static final String COMMANDKEY = "_ ADM-01";
    public static final String SELECTION_PARAMNAME = "selection";
    public static final String WITH_HISTORY_PARAMNAME = "with_history";
    private boolean selection;
    private boolean withHistory;

    public BackupCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return false;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        File backupFile = this.getBackupFile();
        SubsetEligibility subsetEligibility = null;
        if (this.selection) {
            subsetEligibility = SelectionSubsetEligibility.build(this.fichotheque, this.bdfUser.getSelectedFiches());
        }
        BdfServerZip bdfServerZip = new BdfServerZip(this.bdfServer, subsetEligibility);
        try (ZipOutputStream os = new ZipOutputStream(new FileOutputStream(backupFile));){
            bdfServerZip.zip(os);
            if (this.withHistory) {
                BackupZip backupZip = new BackupZip(this.bdfServer, subsetEligibility);
                backupZip.zip(os);
            }
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
        this.putResultObject("obj.backupfilename", backupFile.getName());
        this.setDone("_ done.administration.backup", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.selection = this.requestHandler.isTrue(SELECTION_PARAMNAME);
        this.withHistory = this.requestHandler.isTrue(WITH_HISTORY_PARAMNAME);
    }

    public File getBackupFile() {
        File backupDirectory = ConfigurationUtils.getBackupDirectory(this.bdfServer);
        StringBuilder buf = new StringBuilder();
        buf.append("bdf-");
        buf.append(this.bdfServer.getFichotheque().getFichothequeMetadata().getBaseName());
        if (this.selection) {
            buf.append("-selection");
        }
        buf.append(".zip");
        File backupFile = new File(backupDirectory, buf.toString());
        return backupFile;
    }
}

