/*
 * Decompiled with CFR 0.152.
 */
package net.scrutari.dataexport.xml;

import java.util.LinkedHashMap;
import java.util.Map;
import net.scrutari.dataexport.api.ThesaurusMetadataExport;
import net.scrutari.dataexport.xml.XmlMetadataExport;
import net.scrutari.dataexport.xml.XmlWriter;

public class XmlThesaurusMetadataExport
extends XmlMetadataExport
implements ThesaurusMetadataExport {
    private final Map<String, String> thesaurusMap = new LinkedHashMap<String, String>();

    @Override
    public void setIntitule(int intituleType, String lang, String intituleValue) {
        Map<String, String> map = this.getMap(intituleType);
        map.put(lang, intituleValue);
    }

    @Override
    public void writeXML(XmlWriter xmlWriter) {
        xmlWriter.openTag("thesaurus-metadata");
        this.addMap(1, xmlWriter);
        this.writePhrases(xmlWriter);
        this.writeAttributes(xmlWriter);
        xmlWriter.closeTag("thesaurus-metadata");
    }

    private void addMap(int intituleType, XmlWriter xmlWriter) {
        Map<String, String> map = this.getMap(intituleType);
        if (map.isEmpty()) {
            return;
        }
        String suffix = XmlThesaurusMetadataExport.getSuffix(intituleType);
        xmlWriter.openTag("intitule-" + suffix);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            xmlWriter.addLibElement(entry.getKey(), entry.getValue());
        }
        xmlWriter.closeTag("intitule-" + suffix);
    }

    private Map<String, String> getMap(int type) {
        switch (type) {
            case 1: {
                return this.thesaurusMap;
            }
        }
        throw new IllegalArgumentException("Wrong intituleType = " + type);
    }

    private static String getSuffix(int type) {
        switch (type) {
            case 1: {
                return "thesaurus";
            }
        }
        throw new IllegalArgumentException("Wrong intituleType = " + type);
    }
}

