/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.uml;

import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class CompressionZlib {
    private static final int COMPRESSION_LEVEL = 9;

    public byte[] compress(byte[] in) {
        if (in.length == 0) {
            return null;
        }
        int len = in.length * 2;
        if (len < 1000) {
            len = 1000;
        }
        return this.tryCompress(in, len);
    }

    private byte[] tryCompress(byte[] in, int len) {
        Deflater compresser = new Deflater(9, true);
        compresser.setInput(in);
        compresser.finish();
        byte[] output = new byte[len];
        int compressedDataLength = compresser.deflate(output);
        if (!compresser.finished()) {
            return null;
        }
        byte[] result = this.copyArray(output, compressedDataLength);
        return result;
    }

    public byte[] decompress(byte[] in) throws IOException {
        byte[] in2 = new byte[in.length + 256];
        System.arraycopy(in, 0, in2, 0, in.length);
        int len = 100000;
        byte[] result = null;
        result = this.tryDecompress(in2, len);
        if (result == null) {
            throw new IOException("Too big?");
        }
        return result;
    }

    private byte[] tryDecompress(byte[] in, int len) throws IOException {
        if (len > 200000) {
            throw new IOException("OutOfMemory");
        }
        byte[] tmp = new byte[len];
        Inflater decompresser = new Inflater(true);
        decompresser.setInput(in);
        try {
            int resultLength = decompresser.inflate(tmp);
            if (!decompresser.finished()) {
                return null;
            }
            decompresser.end();
            byte[] result = this.copyArray(tmp, resultLength);
            return result;
        }
        catch (DataFormatException e) {
            throw new IOException(e.toString());
        }
    }

    private byte[] copyArray(byte[] data, int len) {
        byte[] result = new byte[len];
        System.arraycopy(data, 0, result, 0, len);
        return result;
    }
}

