/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text.collation;

import net.mapeadores.util.text.SubstringPosition;
import net.mapeadores.util.text.collation.CollationUnit;

public class CollationUnitPosition {
    private final SubstringPosition substringPosition;
    private final int[] correspondances;

    public CollationUnitPosition(CollationUnit collationUnit, int unitSourceStartIndex) {
        int unitSourceLength = collationUnit.getSourceString().length();
        this.substringPosition = new SubstringPosition(unitSourceStartIndex, unitSourceLength);
        int collatedLength = collationUnit.length();
        this.correspondances = new int[collatedLength];
        for (int i = 0; i < collatedLength; ++i) {
            this.correspondances[i] = collationUnit.sourceIndexOf(i);
        }
    }

    public CollationUnitPosition(SubstringPosition substringPosition, int[] correspondances) {
        this.substringPosition = substringPosition;
        this.correspondances = correspondances;
    }

    public SubstringPosition getPositionInWholeSource() {
        return this.substringPosition;
    }

    public int[] getCorrespondances() {
        return this.correspondances;
    }

    public SubstringPosition convertToPositionInWholeSource(SubstringPosition partOfCollatedString) {
        int beginIndex = this.substringPosition.getBeginIndex() + this.correspondances[partOfCollatedString.getBeginIndex()];
        int length = this.correspondances[partOfCollatedString.getEndIndex()] - this.correspondances[partOfCollatedString.getBeginIndex()] + 1;
        return new SubstringPosition(beginIndex, length);
    }

    public int compareTo(CollationUnitPosition collationUnitPosition) {
        return this.substringPosition.compareTo(collationUnitPosition.substringPosition);
    }
}

