/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text;

import java.util.SortedMap;
import java.util.TreeMap;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.PhraseCache;
import net.mapeadores.util.text.Phrases;
import net.mapeadores.util.text.PhrasesBuilder;

public class PhrasesCache {
    private final SortedMap<String, PhraseCache> cacheMap = new TreeMap<String, PhraseCache>();
    private Phrases cachedPhrases;

    public synchronized void clear() {
        this.cacheMap.clear();
        this.cachedPhrases = null;
    }

    public synchronized void putLabels(String name, Labels labels) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        PhraseCache phraseCache = (PhraseCache)this.cacheMap.get(name);
        if (phraseCache == null) {
            phraseCache = new PhraseCache(name);
            this.cacheMap.put(name, phraseCache);
        }
        this.cachedPhrases = null;
        phraseCache.putLabels(labels);
    }

    public synchronized boolean putLabel(String name, Label label) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        PhraseCache phraseCache = (PhraseCache)this.cacheMap.get(name);
        if (phraseCache == null) {
            phraseCache = new PhraseCache(name);
            this.cacheMap.put(name, phraseCache);
        }
        this.cachedPhrases = null;
        return phraseCache.putLabel(label);
    }

    public synchronized boolean removeLabel(String name, Lang lang) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        PhraseCache phraseCache = (PhraseCache)this.cacheMap.get(name);
        if (phraseCache == null) {
            return false;
        }
        this.cachedPhrases = null;
        boolean done = phraseCache.removeLabel(lang);
        if (phraseCache.isEmpty()) {
            this.cacheMap.remove(name);
        }
        return done;
    }

    public Phrases getPhrases() {
        Phrases phrases = this.cachedPhrases;
        if (phrases == null) {
            phrases = this.cache();
        }
        return phrases;
    }

    private synchronized Phrases cache() {
        Phrases cache;
        this.cachedPhrases = cache = PhrasesBuilder.toPhrases(this.cacheMap);
        return cache;
    }
}

