/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text;

import java.io.Serializable;
import java.text.ParseException;

public final class FileName
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String basename;
    private final String extension;

    private FileName(String basename, String extension) {
        this.basename = basename;
        this.extension = extension;
    }

    public String getBasename() {
        return this.basename;
    }

    public String getExtension() {
        return this.extension;
    }

    public String toString() {
        return this.basename + "." + this.extension;
    }

    public static FileName parse(String s) throws ParseException {
        if (s == null) {
            throw new ParseException("String null", 0);
        }
        int separatorIdx = s.indexOf(47);
        if (separatorIdx != -1) {
            throw new ParseException("Containing /", separatorIdx);
        }
        int length = s.length();
        if (length < 3) {
            throw new ParseException("length < 3", 2);
        }
        int idx = s.lastIndexOf(46);
        if (idx < 1) {
            throw new ParseException("Missing dot", 0);
        }
        if (idx == length - 1) {
            throw new ParseException("Dot at last", length - 1);
        }
        return new FileName(s.substring(0, idx), s.substring(idx + 1));
    }

    public static FileName build(String s) {
        try {
            return FileName.parse(s);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
    }

    public static FileName parse(String s, String defaultExtension) throws ParseException {
        if (s == null) {
            throw new ParseException("String null", 0);
        }
        int length = s.length();
        if (length == 0) {
            throw new ParseException("Empty", 0);
        }
        int separatorIdx = s.indexOf(47);
        if (separatorIdx != -1) {
            throw new ParseException("Containing /", separatorIdx);
        }
        int idx = s.lastIndexOf(46);
        if (idx == -1) {
            return new FileName(s, defaultExtension);
        }
        if (idx == 0) {
            if (length == 1) {
                throw new ParseException("Dot at last", 1);
            }
            return new FileName(s.substring(1), defaultExtension);
        }
        if (idx == length - 1) {
            return new FileName(s.substring(0, length - 1), defaultExtension);
        }
        return new FileName(s.substring(0, idx), s.substring(idx + 1));
    }

    public static String getExtension(String fileName) {
        int idx = fileName.lastIndexOf(46);
        if (idx < 1) {
            return "";
        }
        if (idx == fileName.length() - 1) {
            return "";
        }
        return fileName.substring(idx + 1);
    }
}

