/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.table;

import java.time.LocalDate;
import net.mapeadores.util.date.FuzzyDate;
import net.mapeadores.util.money.Amount;
import net.mapeadores.util.primitives.Decimal;

public interface TableWriter {
    public int startRow();

    public int addIntegerCell(Long var1);

    public int addDecimalCell(Decimal var1);

    public int addStringCell(String var1);

    public int addDateCell(FuzzyDate var1);

    default public int addDateCell(LocalDate localDate) {
        if (localDate == null) {
            return this.addDateCell((FuzzyDate)null);
        }
        return this.addDateCell(FuzzyDate.fromLocalDate(localDate));
    }

    public int addMoneyCell(Amount var1);

    public int addPercentageCell(Decimal var1);

    public int endRow();

    default public int addIntegerCell(int integer) {
        return this.addIntegerCell(Long.valueOf(integer));
    }

    default public int addNullCell(String castType) {
        switch (castType) {
            case "integer": {
                return this.addIntegerCell(null);
            }
            case "decimal": {
                return this.addDecimalCell(null);
            }
            case "date": {
                return this.addDateCell((FuzzyDate)null);
            }
            case "money": {
                return this.addMoneyCell(null);
            }
            case "percentage": {
                return this.addPercentageCell(null);
            }
        }
        return this.addStringCell(null);
    }

    default public int addCell(String castType, Object obj) {
        if (obj == null) {
            return this.addNullCell(castType);
        }
        switch (castType) {
            case "integer": {
                return this.addIntegerCell((Long)obj);
            }
            case "decimal": {
                return this.addDecimalCell((Decimal)obj);
            }
            case "date": {
                return this.addDateCell((FuzzyDate)obj);
            }
            case "money": {
                return this.addMoneyCell((Amount)obj);
            }
            case "percentage": {
                return this.addPercentageCell((Decimal)obj);
            }
        }
        return this.addStringCell((String)obj);
    }
}

