/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.servlets.multipart;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.mapeadores.util.exceptions.NestedLibraryException;
import net.mapeadores.util.request.FileValue;
import net.mapeadores.util.servlets.MultiPartParser;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;

public class DefaultMultiPartParser
implements MultiPartParser {
    @Override
    public boolean isMultiPartContentRequest(HttpServletRequest request) {
        ServletRequestContext requestContext = new ServletRequestContext(request);
        return ServletFileUpload.isMultipartContent((RequestContext)requestContext);
    }

    @Override
    public Map<String, Object> parseMultiPartContentRequest(HttpServletRequest request) {
        DiskFileItemFactory fileItemFactory = new DiskFileItemFactory();
        ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)fileItemFactory);
        servletFileUpload.setSizeMax(-1L);
        try {
            List fileItemList = servletFileUpload.parseRequest(request);
            MultiPartValueMapBuilder builder = new MultiPartValueMapBuilder(request.getCharacterEncoding());
            for (FileItem fileItem : fileItemList) {
                builder.addFileItem(fileItem);
            }
            return builder.getMultiPartValueMap();
        }
        catch (FileUploadException fue) {
            throw new NestedLibraryException((Exception)((Object)fue));
        }
    }

    private class MultiPartValueMapBuilder {
        Map<String, Object> multiPartValueMap = new HashMap<String, Object>();
        String charsetName;

        MultiPartValueMapBuilder(String charsetName) {
            this.charsetName = charsetName == null ? "UTF-8" : charsetName;
        }

        Map<String, Object> getMultiPartValueMap() {
            return this.multiPartValueMap;
        }

        private void addFileItem(FileItem fileItem) {
            if (fileItem.isFormField()) {
                this.addString(fileItem);
            } else {
                this.addFileValue(fileItem);
            }
        }

        private void addString(FileItem fileItem) {
            String value;
            String name = fileItem.getFieldName();
            try {
                value = fileItem.getString(this.charsetName);
            }
            catch (IOException ioe) {
                value = fileItem.getString();
            }
            Object current = this.multiPartValueMap.get(name);
            if (current == null) {
                this.multiPartValueMap.put(name, value);
            } else if (current instanceof String[]) {
                String[] currentArray = (String[])current;
                int length = currentArray.length;
                String[] newArray = new String[length + 1];
                System.arraycopy(currentArray, 0, newArray, 0, length);
                newArray[length] = value;
                this.multiPartValueMap.put(name, newArray);
            } else if (current instanceof String) {
                String[] array = new String[]{(String)current, value};
                this.multiPartValueMap.put(name, array);
            }
        }

        private void addFileValue(FileItem fileItem) {
            String name = fileItem.getFieldName();
            InternalFileValue value = new InternalFileValue(fileItem);
            Object current = this.multiPartValueMap.get(name);
            if (current == null) {
                this.multiPartValueMap.put(name, value);
            } else if (current instanceof FileValue[]) {
                FileValue[] currentArray = (FileValue[])current;
                int length = currentArray.length;
                FileValue[] newArray = new FileValue[length + 1];
                System.arraycopy(currentArray, 0, newArray, 0, length);
                newArray[length] = value;
                this.multiPartValueMap.put(name, newArray);
            } else if (current instanceof FileValue) {
                FileValue[] array = new FileValue[]{(FileValue)current, value};
                this.multiPartValueMap.put(name, array);
            }
        }
    }

    private static class InternalFileValue
    implements FileValue {
        private final FileItem fileItem;

        InternalFileValue(FileItem fileItem) {
            this.fileItem = fileItem;
        }

        @Override
        public String getName() {
            return this.fileItem.getName();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.fileItem.getInputStream();
        }

        @Override
        public void free() {
            this.fileItem.delete();
        }

        @Override
        public long length() {
            return this.fileItem.getSize();
        }
    }
}

