/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.mapeadores.util.request.FileValue;
import net.mapeadores.util.request.RequestMap;

public class RequestMapBuilder {
    private final Map<String, List<String>> parameterMap = new HashMap<String, List<String>>();

    public RequestMapBuilder addParameter(String name, String value) {
        List<String> currentList = this.parameterMap.get(name);
        if (currentList == null) {
            currentList = new ArrayList<String>();
            this.parameterMap.put(name, currentList);
        }
        currentList.add(value);
        return this;
    }

    public RequestMap toRequestMap() {
        HashMap<String, String[]> finalMap = new HashMap<String, String[]>();
        for (Map.Entry<String, List<String>> entry : this.parameterMap.entrySet()) {
            List<String> values = entry.getValue();
            if (values.isEmpty()) continue;
            String[] finalValues = values.toArray(new String[values.size()]);
            finalMap.put(entry.getKey(), finalValues);
        }
        return new InternalRequestMap(finalMap);
    }

    private static class InternalRequestMap
    implements RequestMap {
        private final Map<String, String[]> parameterMap;
        private final Set<String> nameSet;

        private InternalRequestMap(Map<String, String[]> parameterMap) {
            this.parameterMap = parameterMap;
            this.nameSet = Collections.unmodifiableSet(parameterMap.keySet());
        }

        @Override
        public FileValue getFileValue(String name) {
            return null;
        }

        @Override
        public FileValue[] getFileValues(String name) {
            return null;
        }

        @Override
        public String getParameter(String name) {
            String[] array = this.parameterMap.get(name);
            if (array == null) {
                return null;
            }
            return array[0];
        }

        @Override
        public String[] getParameterValues(String name) {
            return this.parameterMap.get(name);
        }

        @Override
        public Set<String> getParameterNameSet() {
            return this.nameSet;
        }

        @Override
        public Locale[] getAcceptableLocaleArray() {
            return null;
        }

        @Override
        public Object getSourceObject() {
            return null;
        }
    }
}

