/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.request;

import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.request.RequestMap;

public class OutputInfo {
    public static final short UNKNOWN_TYPE = 0;
    public static final short STREAM_TYPE = 1;
    public static final short JSON_TYPE = 2;
    public static final short PAGE_TYPE = 3;
    private final short type;
    private final String output;

    public OutputInfo(short type, String output) {
        if (output != null && output.length() == 0) {
            output = null;
        }
        this.type = type;
        this.output = output;
    }

    public static OutputInfo buildFromRequest(RequestMap requestMap) {
        return OutputInfo.buildFromRequest(requestMap, null);
    }

    public static OutputInfo buildFromRequest(RequestMap requestMap, @Nullable String defaultPage) {
        short type;
        int idx;
        String jsonType = requestMap.getParameter("jsontype");
        if (jsonType != null) {
            return new OutputInfo(2, requestMap.getParameter("json"));
        }
        String json = requestMap.getParameter("json");
        if (json != null) {
            return new OutputInfo(2, json);
        }
        String page = requestMap.getParameter("page");
        if (page != null) {
            return new OutputInfo(3, page);
        }
        String stream = requestMap.getParameter("stream");
        if (stream != null) {
            return new OutputInfo(1, stream);
        }
        String output = requestMap.getParameter("output");
        if (output != null && (idx = output.indexOf(124)) != -1 && (type = OutputInfo.toType(output.substring(0, idx))) != 0) {
            return new OutputInfo(type, output.substring(idx + 1));
        }
        if (defaultPage != null) {
            return new OutputInfo(3, defaultPage);
        }
        return new OutputInfo(0, null);
    }

    private static short toType(String s) {
        if (s.equals("stream")) {
            return 1;
        }
        if (s.equals("page")) {
            return 3;
        }
        if (s.equals("json")) {
            return 2;
        }
        return 0;
    }

    public short getType() {
        return this.type;
    }

    public String getOutput() {
        return this.output;
    }

    public boolean hasOutput() {
        return this.output != null;
    }
}

