/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.primitives.io;

import java.io.IOException;
import java.util.List;
import net.mapeadores.util.primitives.PrimUtils;

public interface PrimitivesWriter {
    public void writeInt(int var1) throws IOException;

    public void writeShort(short var1) throws IOException;

    public void writeByte(byte var1) throws IOException;

    public void writeString(String var1) throws IOException;

    public void writeBoolean(boolean var1) throws IOException;

    public void writeChar(char var1) throws IOException;

    public void writeDouble(double var1) throws IOException;

    public void writeLong(long var1) throws IOException;

    public void writeFloat(float var1) throws IOException;

    public void write(byte[] var1, int var2, int var3) throws IOException;

    default public void writeIntArray(int[] intArray) throws IOException {
        int length = intArray.length;
        int bufferLength = (length + 1) * 4;
        byte[] buffer = new byte[bufferLength];
        PrimUtils.convertInt(length, buffer);
        for (int i = 0; i < length; ++i) {
            PrimUtils.convertInt(intArray[i], buffer, (i + 1) * 4);
        }
        this.write(buffer, 0, bufferLength);
    }

    default public void writeIntArray(List<Integer> integerList) throws IOException {
        int length = integerList.size();
        int bufferLength = (length + 1) * 4;
        byte[] buffer = new byte[bufferLength];
        PrimUtils.convertInt(length, buffer);
        for (int i = 0; i < length; ++i) {
            PrimUtils.convertInt(integerList.get(i), buffer, (i + 1) * 4);
        }
        this.write(buffer, 0, bufferLength);
    }

    default public void writeLongString(String s) throws IOException {
        if (s == null) {
            this.writeInt(-1);
        } else if (s.isEmpty()) {
            this.writeInt(0);
        } else {
            byte[] b = s.getBytes("UTF-8");
            this.writeInt(b.length);
            this.write(b, 0, b.length);
        }
    }
}

