/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.primitives.io;

import java.io.IOException;
import net.mapeadores.util.primitives.PrimUtils;

public interface PrimitivesReader {
    public int readInt() throws IOException;

    public short readShort() throws IOException;

    public boolean readBoolean() throws IOException;

    public char readChar() throws IOException;

    public String readString() throws IOException;

    public double readDouble() throws IOException;

    public long readLong() throws IOException;

    public byte readByte() throws IOException;

    public float readFloat() throws IOException;

    public int skipBytes(int var1) throws IOException;

    public void read(byte[] var1, int var2, int var3) throws IOException;

    default public int[] readInts(int size) throws IOException {
        int bufferLength = size * 4;
        byte[] buffer = new byte[bufferLength];
        this.read(buffer, 0, bufferLength);
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = PrimUtils.toInt(buffer, i * 4);
        }
        return result;
    }

    default public Integer[] readIntegers(int size) throws IOException {
        int bufferLength = size * 4;
        byte[] buffer = new byte[bufferLength];
        this.read(buffer, 0, bufferLength);
        Integer[] result = new Integer[size];
        for (int i = 0; i < size; ++i) {
            result[i] = PrimUtils.toInt(buffer, i * 4);
        }
        return result;
    }

    default public void skipInts(int size) throws IOException {
        this.skipBytes(size * 4);
    }

    default public void skipLongs(int size) throws IOException {
        this.skipBytes(size * 8);
    }

    default public void skipIntArray() throws IOException {
        int length = this.readInt();
        this.skipInts(length);
    }

    default public int[] readIntArray() throws IOException {
        int length = this.readInt();
        return this.readInts(length);
    }

    default public Integer[] readIntegerArray() throws IOException {
        int length = this.readInt();
        return this.readIntegers(length);
    }

    default public String readLongString() throws IOException {
        int length = this.readInt();
        switch (length) {
            case -1: {
                return null;
            }
            case 0: {
                return "";
            }
        }
        byte[] bytes = new byte[length];
        this.read(bytes, 0, length);
        return new String(bytes, "UTF-8");
    }
}

