/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.jslib;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.mapeadores.util.jslib.JsLib;
import net.mapeadores.util.jslib.JsLibUtils;
import net.mapeadores.util.jslib.TemplateFamily;
import net.mapeadores.util.jslib.ThirdLib;
import net.mapeadores.util.text.RelativePath;
import net.mapeadores.util.text.StringUtils;

public class JsLibBuilder {
    private final List<JsLib> dependencyList = new ArrayList<JsLib>();
    private final List<RelativePath> jsScriptList = new ArrayList<RelativePath>();
    private final List<ThirdLib> thirdLibList = new ArrayList<ThirdLib>();
    private final List<TemplateFamily> templateFamilyList = new ArrayList<TemplateFamily>();
    private final List<RelativePath> cssPathList = new ArrayList<RelativePath>();
    private final Set<String> existingCss = new HashSet<String>();
    private final Set<String> existingJs = new HashSet<String>();

    public JsLibBuilder addCssPath(RelativePath relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException("cssPath is null");
        }
        String path = relativePath.getPath();
        if (!this.existingCss.contains(path)) {
            this.cssPathList.add(relativePath);
            this.existingCss.add(path);
        }
        return this;
    }

    public JsLibBuilder addDependency(JsLib dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException("dependency is null");
        }
        this.dependencyList.add(dependency);
        return this;
    }

    public JsLibBuilder addJsScript(RelativePath relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException("relativePath is null");
        }
        String path = relativePath.getPath();
        if (!this.existingJs.contains(path)) {
            this.jsScriptList.add(relativePath);
            this.existingJs.add(path);
        }
        return this;
    }

    public JsLibBuilder addTemplateFamily(TemplateFamily templateFamily) {
        if (templateFamily == null) {
            throw new IllegalArgumentException("templateFamily is null");
        }
        this.templateFamilyList.add(templateFamily);
        return this;
    }

    public JsLibBuilder addThirdLib(ThirdLib thirdLib) {
        if (thirdLib == null) {
            throw new IllegalArgumentException("thirdLib is null");
        }
        this.thirdLibList.add(thirdLib);
        return this;
    }

    public JsLib toJsLib() {
        List<JsLib> finalDependencyList = this.dependencyList.isEmpty() ? JsLibUtils.EMPTY_JSLIBLIST : JsLibUtils.wrap(this.dependencyList.toArray(new JsLib[this.dependencyList.size()]));
        List<RelativePath> finalJsScriptList = this.jsScriptList.isEmpty() ? StringUtils.EMPTY_RELATIVEPATHLIST : StringUtils.wrap(this.jsScriptList.toArray(new RelativePath[this.jsScriptList.size()]));
        List<ThirdLib> finalThirdLibList = this.thirdLibList.isEmpty() ? JsLibUtils.EMPTY_THIRDLIBLIST : JsLibUtils.wrap(this.thirdLibList.toArray(new ThirdLib[this.thirdLibList.size()]));
        List<TemplateFamily> finalJsrenderTemplateList = this.templateFamilyList.isEmpty() ? JsLibUtils.EMPTY_TEMPLATEFAMILYLIST : JsLibUtils.wrap(this.templateFamilyList.toArray(new TemplateFamily[this.templateFamilyList.size()]));
        List<RelativePath> finalcssPathList = this.cssPathList.isEmpty() ? StringUtils.EMPTY_RELATIVEPATHLIST : StringUtils.wrap(this.cssPathList.toArray(new RelativePath[this.cssPathList.size()]));
        return new InternalJsLib(finalDependencyList, finalJsScriptList, finalThirdLibList, finalJsrenderTemplateList, finalcssPathList);
    }

    public static JsLibBuilder init() {
        return new JsLibBuilder();
    }

    private static class InternalJsLib
    implements JsLib {
        private final List<JsLib> dependencyList;
        private final List<RelativePath> jsScriptList;
        private final List<ThirdLib> thirdLibList;
        private final List<TemplateFamily> templateList;
        private final List<RelativePath> cssPathList;

        private InternalJsLib(List<JsLib> dependencyList, List<RelativePath> jsScriptList, List<ThirdLib> thirdLibList, List<TemplateFamily> templateList, List<RelativePath> cssPathList) {
            this.dependencyList = dependencyList;
            this.jsScriptList = jsScriptList;
            this.thirdLibList = thirdLibList;
            this.templateList = templateList;
            this.cssPathList = cssPathList;
        }

        @Override
        public List<JsLib> getDependencyList() {
            return this.dependencyList;
        }

        @Override
        public List<RelativePath> getJsScriptList() {
            return this.jsScriptList;
        }

        @Override
        public List<ThirdLib> getThirdLibList() {
            return this.thirdLibList;
        }

        @Override
        public List<TemplateFamily> getTemplateFamilyList() {
            return this.templateList;
        }

        @Override
        public List<RelativePath> getCssPathList() {
            return this.cssPathList;
        }
    }
}

