/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.io;

import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mapeadores.util.io.ResourceFolder;
import net.mapeadores.util.io.ResourceStorage;
import net.mapeadores.util.io.ResourceStorages;
import net.mapeadores.util.text.RelativePath;
import net.mapeadores.util.text.StringUtils;

public final class ResourceUtils {
    public static final ResourceFolder EMPTY_ROOTFOLDER = new EmptyRootFolder();
    public static final Pattern NAME_PATTERN = Pattern.compile("^[_a-zA-Z][-_.a-zA-Z0-9]*$");

    private ResourceUtils() {
    }

    public static ResourceStorages toResourceStorages(ResourceStorage[] array) {
        return new InternalResourceStorages(array);
    }

    public static List<ResourceFolder> wrap(ResourceFolder[] array) {
        return new ResourceFolderList(array);
    }

    public static boolean isValidResourceName(String name) {
        Matcher matcher = NAME_PATTERN.matcher(name);
        if (matcher.matches()) {
            int idx = name.indexOf(46);
            return idx > 0 && idx < name.length() - 1;
        }
        return false;
    }

    public static boolean isValidFolderName(String name) {
        Matcher matcher = NAME_PATTERN.matcher(name);
        return matcher.matches();
    }

    public static boolean isValidResourceRelativePath(RelativePath relativePath) {
        String[] array = relativePath.toArray();
        int length = array.length;
        if (length < 2) {
            return false;
        }
        for (int i = 0; i < length - 1; ++i) {
            String name = array[i];
            if (ResourceUtils.isValidFolderName(name)) continue;
            return false;
        }
        return ResourceUtils.isValidResourceName(array[length - 1]);
    }

    static void addSubressources(SortedMap<String, RelativePath> map, ResourceFolder folder, RelativePath folderPath, String pathToRoot) {
        for (String resourceName : folder.getResourceNameList()) {
            RelativePath resourcePath = folderPath.buildChild(resourceName);
            map.put(pathToRoot + resourceName, resourcePath);
        }
        for (ResourceFolder subfolder : folder.getSubfolderList()) {
            String folderName = subfolder.getName();
            ResourceUtils.addSubressources(map, subfolder, folderPath.buildChild(folderName), pathToRoot + folderName + "/");
        }
    }

    private static class InternalResourceStorages
    extends AbstractList<ResourceStorage>
    implements ResourceStorages {
        private final ResourceStorage[] array;

        private InternalResourceStorages(ResourceStorage[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public ResourceStorage get(int index) {
            return this.array[index];
        }

        @Override
        public ResourceStorage getResourceStorage(String name) {
            for (ResourceStorage resourceStorage : this.array) {
                if (!resourceStorage.getName().equals(name)) continue;
                return resourceStorage;
            }
            return null;
        }
    }

    private static class ResourceFolderList
    extends AbstractList<ResourceFolder>
    implements RandomAccess {
        private final ResourceFolder[] array;

        private ResourceFolderList(ResourceFolder[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public ResourceFolder get(int index) {
            return this.array[index];
        }
    }

    private static class EmptyRootFolder
    implements ResourceFolder {
        private final List<ResourceFolder> emptyList = Collections.emptyList();

        private EmptyRootFolder() {
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public List<ResourceFolder> getSubfolderList() {
            return this.emptyList;
        }

        @Override
        public List<String> getResourceNameList() {
            return StringUtils.EMPTY_STRINGLIST;
        }
    }
}

