/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.date;

import java.time.LocalDate;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.Locale;
import net.mapeadores.util.annotation.Nullable;

public final class DateUtils {
    public static final String ISO_JAVAPATTERN = "y-MM-dd";

    private DateUtils() {
    }

    public static String isoNow() {
        return DateTimeFormatter.ISO_LOCAL_DATE.format(LocalDate.now());
    }

    public static int getLastDayOfMonth(int month, int year) {
        switch (month) {
            case 1: {
                return 31;
            }
            case 2: {
                if (DateUtils.isLeapYear(year)) {
                    return 29;
                }
                return 28;
            }
            case 3: {
                return 31;
            }
            case 4: {
                return 30;
            }
            case 5: {
                return 31;
            }
            case 6: {
                return 30;
            }
            case 7: {
                return 31;
            }
            case 8: {
                return 31;
            }
            case 9: {
                return 30;
            }
            case 10: {
                return 31;
            }
            case 11: {
                return 30;
            }
            case 12: {
                return 31;
            }
        }
        throw new IllegalArgumentException("unknown mois");
    }

    public static boolean isLeapYear(int year) {
        if (year % 4 != 0) {
            return false;
        }
        if (year % 400 == 0) {
            return true;
        }
        return year % 100 != 0;
    }

    public static int compare(@Nullable LocalDate date1, @Nullable LocalDate date2) {
        if (date1 != null) {
            if (date2 == null) {
                return 1;
            }
            return date1.compareTo(date2);
        }
        if (date2 != null) {
            return -1;
        }
        return 0;
    }

    public static LocalDate max(@Nullable LocalDate date1, @Nullable LocalDate date2) {
        int comp = DateUtils.compare(date1, date2);
        if (comp < 0) {
            return date2;
        }
        return date1;
    }

    public static String getLocalizedPattern(FormatStyle formatStyle, Locale locale) {
        return DateTimeFormatterBuilder.getLocalizedDateTimePattern(formatStyle, null, IsoChronology.INSTANCE, locale);
    }
}

