/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.conditions;

import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;
import net.mapeadores.util.conditions.ConditionsConstants;
import net.mapeadores.util.conditions.TextCondition;
import net.mapeadores.util.conditions.TextConditionBuilder;
import net.mapeadores.util.conditions.TextTest;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.text.search.MultiSearchToken;
import net.mapeadores.util.text.search.SearchToken;
import net.mapeadores.util.text.search.SearchTokenParser;
import net.mapeadores.util.text.search.SimpleSearchToken;

public final class ConditionsUtils {
    public static final TextTest EMPTY_TEXTTEST = new InternalTextTest(15, "");
    public static final TextTest FILLED_TEXTTEST = new InternalTextTest(20, "");

    private ConditionsUtils() {
    }

    public static boolean accept(TextTest textTest, String contentString) {
        short testType;
        if (contentString == null) {
            contentString = "";
        }
        if ((testType = textTest.getTestType()) == 15) {
            return contentString.length() == 0;
        }
        if (testType == 20) {
            return contentString.length() > 0;
        }
        String testString = textTest.getText().toLowerCase();
        contentString = contentString.toLowerCase();
        if (ConditionsUtils.isExcludingPartTestType(testType)) {
            switch (testType) {
                case 19: {
                    return !contentString.equals(testString);
                }
                case 16: {
                    return !contentString.startsWith(testString);
                }
                case 17: {
                    return !contentString.endsWith(testString);
                }
            }
            return !contentString.contains(testString);
        }
        switch (testType) {
            case 14: {
                return contentString.equals(testString);
            }
            case 11: {
                return contentString.startsWith(testString);
            }
            case 12: {
                return contentString.endsWith(testString);
            }
        }
        return contentString.contains(testString);
    }

    public static TextCondition parseSimpleCondition(String conditionString) {
        if (conditionString == null) {
            return null;
        }
        int length = (conditionString = conditionString.trim()).length();
        if (length == 0) {
            return null;
        }
        String operator = "and";
        if (conditionString.charAt(0) == '|') {
            if (length == 1) {
                return null;
            }
            operator = "or";
            conditionString = conditionString.substring(1).trim();
        }
        return ConditionsUtils.parseSimpleCondition(conditionString, operator);
    }

    public static TextCondition parseSimpleCondition(String conditionString, String operator) {
        String[] tokens;
        if (conditionString == null) {
            return null;
        }
        int length = (conditionString = conditionString.trim()).length();
        if (length == 0) {
            return null;
        }
        if (length == 1 && conditionString.charAt(0) == '!') {
            return null;
        }
        for (int i = 0; i < length; ++i) {
            char carac = conditionString.charAt(i);
            switch (carac) {
                case '*': 
                case ';': {
                    return ConditionsUtils.parseCondition(conditionString, operator);
                }
            }
        }
        TextConditionBuilder conditionBuilder = new TextConditionBuilder(operator);
        for (String token : tokens = StringUtils.getTokens(conditionString, ' ', (short)2)) {
            int testType = 13;
            if (token.charAt(0) == '!') {
                if (token.length() == 1) continue;
                testType = 18;
                token = token.substring(1);
            }
            conditionBuilder.addTextTest(ConditionsUtils.toTextTest((short)testType, token));
        }
        return conditionBuilder.toTextCondition();
    }

    public static TextCondition parseSequenceCondition(String conditionString, String operator) {
        if (conditionString == null) {
            return null;
        }
        int length = (conditionString = conditionString.trim()).length();
        if (length == 0) {
            return null;
        }
        List<SearchToken> searchTokenList = SearchTokenParser.parse(operator, 1);
        if (searchTokenList.isEmpty()) {
            return null;
        }
        TextConditionBuilder conditionBuilder = new TextConditionBuilder(operator);
        for (SearchToken searchToken : searchTokenList) {
            if (searchToken instanceof SimpleSearchToken) {
                SimpleSearchToken simpleSearchToken = (SimpleSearchToken)searchToken;
                conditionBuilder.addTextTest(ConditionsUtils.toTextTest(ConditionsConstants.convertSearchType(simpleSearchToken.getSearchType()), simpleSearchToken.getTokenString()));
                continue;
            }
            MultiSearchToken multiSearchToken = (MultiSearchToken)searchToken;
            int count = multiSearchToken.getSubtokenCount();
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    buf.append(' ');
                }
                buf.append(multiSearchToken.getSubtoken(i).getTokenString());
            }
            conditionBuilder.addTextTest(ConditionsUtils.toTextTest((short)14, buf.toString()));
        }
        return conditionBuilder.toTextCondition();
    }

    public static TextCondition parseCondition(String conditionString, String operator) {
        TextConditionBuilder conditionBuilder = new TextConditionBuilder(operator);
        int length = conditionString.length();
        boolean previousEscaped = false;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char carac = conditionString.charAt(i);
            if (previousEscaped) {
                if (carac != ';') {
                    buf.append('\\');
                }
                buf.append(carac);
                previousEscaped = false;
                continue;
            }
            if (carac == ';') {
                if (buf.length() <= 0) continue;
                conditionBuilder.addTextTest(buf.toString());
                buf = new StringBuilder();
                continue;
            }
            if (carac == '\\') {
                previousEscaped = true;
                continue;
            }
            buf.append(carac);
        }
        if (previousEscaped) {
            buf.append('\\');
        }
        conditionBuilder.addTextTest(buf.toString());
        return conditionBuilder.toTextCondition();
    }

    public static TextTest parseTextTest(String testString) {
        String text;
        boolean non;
        if (testString == null) {
            return null;
        }
        if ((testString = testString.trim()).length() == 0) {
            return null;
        }
        boolean bl = non = testString.charAt(0) == '!';
        if (non && testString.length() == 1) {
            return EMPTY_TEXTTEST;
        }
        if (non) {
            testString = testString.substring(1);
        }
        boolean commence = false;
        if (testString.charAt(0) == '*' || testString.charAt(0) == '%') {
            commence = true;
            text = testString.substring(1);
        } else if (testString.startsWith("..")) {
            commence = true;
            text = testString.substring(2);
        } else {
            text = testString;
        }
        text = StringUtils.cleanString(text);
        int taille = text.length();
        if (text.length() == 0) {
            if (non) {
                return EMPTY_TEXTTEST;
            }
            return FILLED_TEXTTEST;
        }
        boolean finit = false;
        if (text.charAt(taille - 1) == '*' || text.charAt(taille - 1) == '%') {
            text = text.substring(0, taille - 1);
            finit = true;
        } else if (text.endsWith("..")) {
            text = text.substring(0, taille - 2);
            finit = true;
        }
        short testType = commence ? (finit ? (non ? (short)18 : 13) : (non ? (short)17 : 12)) : (finit ? (non ? (short)16 : 11) : (non ? (short)19 : 14));
        return ConditionsUtils.toTextTest(testType, text);
    }

    public static TextTest toOpposite(TextTest textTest) {
        short oppositeType = ConditionsUtils.getOppositeTestType(textTest.getTestType());
        return ConditionsUtils.toTextTest(oppositeType, textTest.getText());
    }

    public static short getOppositeTestType(short testType) {
        switch (testType) {
            case 11: {
                return 16;
            }
            case 12: {
                return 17;
            }
            case 13: {
                return 18;
            }
            case 14: {
                return 19;
            }
            case 15: {
                return 20;
            }
            case 16: {
                return 11;
            }
            case 17: {
                return 12;
            }
            case 18: {
                return 13;
            }
            case 19: {
                return 14;
            }
            case 20: {
                return 15;
            }
        }
        return -1;
    }

    public static String toSQL(TextTest textTest) {
        StringBuilder buf = new StringBuilder();
        switch (textTest.getTestType()) {
            case 15: {
                buf.append(" IS NULL");
                break;
            }
            case 20: {
                buf.append(" IS NOT NULL");
                break;
            }
            case 11: {
                buf.append(" LIKE '");
                ConditionsUtils.preparation(buf, textTest);
                buf.append("%'");
                break;
            }
            case 12: {
                buf.append(" LIKE '%");
                ConditionsUtils.preparation(buf, textTest);
                buf.append("'");
                break;
            }
            case 13: {
                buf.append(" LIKE '%");
                ConditionsUtils.preparation(buf, textTest);
                buf.append("%'");
                break;
            }
            case 14: {
                buf.append(" LIKE '");
                ConditionsUtils.preparation(buf, textTest);
                buf.append("'");
                break;
            }
            case 16: {
                buf.append(" NOT LIKE '%");
                ConditionsUtils.preparation(buf, textTest);
                buf.append("%'");
                break;
            }
            case 17: {
                buf.append(" NOT LIKE '%");
                ConditionsUtils.preparation(buf, textTest);
                buf.append("'");
                break;
            }
            case 18: {
                buf.append(" NOT LIKE '%");
                ConditionsUtils.preparation(buf, textTest);
                buf.append("%'");
                break;
            }
            case 19: {
                buf.append(" NOT LIKE '");
                ConditionsUtils.preparation(buf, textTest);
                buf.append("'");
            }
        }
        return buf.toString();
    }

    private static void preparation(StringBuilder buf, TextTest textTest) {
        String text = textTest.getText();
        for (int i = 0; i < text.length(); ++i) {
            char carac = text.charAt(i);
            if (carac == '\'') {
                buf.append("''");
                continue;
            }
            buf.append(carac);
        }
    }

    public static boolean isExcludingPartTestType(short testType) {
        switch (testType) {
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIncludingPartTestType(short testType) {
        switch (testType) {
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    public static String conditionToSimpleString(TextCondition condition, boolean withOperator) {
        if (!ConditionsUtils.isSimpleCondition(condition)) {
            String conditionString = ConditionsUtils.conditionToString(condition);
            if (conditionString.length() > 0) {
                String operatorPrefix = withOperator && condition.isOrOperator() ? "|" : "";
                conditionString = operatorPrefix + conditionString + ";";
            }
            return conditionString;
        }
        StringBuilder buf = new StringBuilder();
        if (withOperator && condition.isOrOperator()) {
            buf.append('|');
        }
        for (TextTest textTest : condition.getIncludingTextTestList()) {
            buf.append(textTest.getText());
            buf.append(' ');
        }
        for (TextTest textTest : condition.getExcludingTextTestList()) {
            buf.append('!');
            buf.append(textTest.getText());
            buf.append(' ');
        }
        return buf.toString();
    }

    public static String conditionToString(TextCondition condition) {
        StringBuilder buf = new StringBuilder();
        boolean next = false;
        for (TextTest textTest : condition.getIncludingTextTestList()) {
            if (next) {
                buf.append(';');
            } else {
                next = true;
            }
            buf.append(textTest.getCompleteText());
        }
        for (TextTest textTest : condition.getExcludingTextTestList()) {
            if (next) {
                buf.append(';');
            } else {
                next = true;
            }
            buf.append(textTest.getCompleteText());
        }
        return buf.toString();
    }

    public static String testTypeToString(short testType) {
        switch (testType) {
            case 11: {
                return ".*";
            }
            case 12: {
                return "*.";
            }
            case 13: {
                return "*.*";
            }
            case 14: {
                return ".";
            }
            case 15: {
                return "!*";
            }
            case 16: {
                return "!.*";
            }
            case 17: {
                return "!*.";
            }
            case 18: {
                return "!*.*";
            }
            case 19: {
                return "!.";
            }
            case 20: {
                return "*";
            }
        }
        throw new IllegalArgumentException("wrong testType value = " + testType);
    }

    public static short testTypeToShort(String type) {
        if (type.equals(".*")) {
            return 11;
        }
        if (type.equals("*.")) {
            return 12;
        }
        if (type.equals("*.*")) {
            return 13;
        }
        if (type.equals(".")) {
            return 14;
        }
        if (type.equals("!*")) {
            return 15;
        }
        if (type.equals("!.*")) {
            return 16;
        }
        if (type.equals("!*.")) {
            return 17;
        }
        if (type.equals("!*.*")) {
            return 18;
        }
        if (type.equals("!.")) {
            return 19;
        }
        if (type.equals("*")) {
            return 20;
        }
        throw new IllegalArgumentException("wrong type value = " + type);
    }

    public static short getState(TextTest textTest) {
        switch (textTest.getTestType()) {
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return 5;
            }
            case 15: {
                return 3;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return 6;
            }
            case 20: {
                return 4;
            }
        }
        throw new IllegalArgumentException("unknown conditionType");
    }

    public static short merge(String logicalOperator, short currentState, short addingState) {
        if (currentState == 0) {
            return addingState;
        }
        if (currentState == addingState) {
            return currentState;
        }
        if (logicalOperator.equals("and")) {
            return ConditionsUtils.mergeAndMode(currentState, addingState);
        }
        return ConditionsUtils.mergeOrMode(currentState, addingState);
    }

    public static short mergeAndMode(short currentState, short addingState) {
        if (currentState == 2) {
            return 2;
        }
        if (currentState == 1) {
            return addingState;
        }
        if (currentState == 3) {
            switch (addingState) {
                case 4: 
                case 5: {
                    return 2;
                }
                case 6: {
                    return 3;
                }
            }
            return currentState;
        }
        if (currentState == 4) {
            switch (addingState) {
                case 3: {
                    return 2;
                }
                case 5: 
                case 6: {
                    return 5;
                }
            }
            return currentState;
        }
        if (currentState == 5) {
            switch (addingState) {
                case 3: {
                    return 2;
                }
                case 4: 
                case 6: {
                    return 5;
                }
            }
            return currentState;
        }
        if (currentState == 6) {
            switch (addingState) {
                case 3: {
                    return 3;
                }
                case 4: 
                case 5: {
                    return 5;
                }
            }
            return currentState;
        }
        throw new IllegalArgumentException();
    }

    public static short mergeOrMode(short currentState, short addingState) {
        if (currentState == 2) {
            return addingState;
        }
        if (currentState == 1) {
            return 1;
        }
        if (currentState == 3) {
            switch (addingState) {
                case 4: {
                    return 1;
                }
                case 5: 
                case 6: {
                    return 6;
                }
            }
            return currentState;
        }
        if (currentState == 4) {
            switch (addingState) {
                case 3: {
                    return 1;
                }
                case 5: {
                    return 4;
                }
                case 6: {
                    return 1;
                }
            }
            return currentState;
        }
        if (currentState == 5) {
            switch (addingState) {
                case 3: {
                    return 6;
                }
                case 4: {
                    return 4;
                }
                case 6: {
                    return 6;
                }
            }
            return currentState;
        }
        if (currentState == 6) {
            switch (addingState) {
                case 3: {
                    return 6;
                }
                case 4: {
                    return 1;
                }
                case 5: {
                    return 6;
                }
            }
            return currentState;
        }
        throw new IllegalArgumentException();
    }

    public static boolean isPartialState(short state) {
        return state == 5 || state == 6;
    }

    public static TextTest toTextTest(short testType, String text) {
        return new InternalTextTest(testType, text);
    }

    public static TextTest cloneTextTest(TextTest textTest) {
        short testType = textTest.getTestType();
        switch (testType) {
            case 15: {
                return EMPTY_TEXTTEST;
            }
            case 20: {
                return FILLED_TEXTTEST;
            }
        }
        return new InternalTextTest(testType, textTest.getText());
    }

    public static boolean isNeutral(TextCondition condition) {
        short state = ConditionsUtils.getConditionType(condition);
        return state == 0 || state == 1;
    }

    public static short getConditionType(TextCondition condition) {
        String logicalOperator = condition.getLogicalOperator();
        short state = 0;
        for (TextTest textTest : condition.getExcludingTextTestList()) {
            state = ConditionsUtils.merge(logicalOperator, state, ConditionsUtils.getState(textTest));
        }
        for (TextTest textTest : condition.getIncludingTextTestList()) {
            state = ConditionsUtils.merge(logicalOperator, state, ConditionsUtils.getState(textTest));
        }
        return state;
    }

    public static List<TextTest> wrap(TextTest[] array) {
        return new TextTestList(array);
    }

    private static boolean isSimpleCondition(TextCondition condition) {
        String text;
        short conditionType = ConditionsUtils.getConditionType(condition);
        List<TextTest> excludingTextTestList = condition.getExcludingTextTestList();
        if (conditionType == 6 ? excludingTextTestList.isEmpty() : conditionType != 5) {
            return false;
        }
        for (TextTest textTest : condition.getIncludingTextTestList()) {
            if (textTest.getTestType() != 13) {
                return false;
            }
            text = textTest.getText();
            if (text.indexOf(32) != -1) {
                return false;
            }
            if (text.equals("!")) {
                return false;
            }
            if (!text.equals("|")) continue;
            return false;
        }
        for (TextTest textTest : excludingTextTestList) {
            if (textTest.getTestType() != 18) {
                return false;
            }
            text = textTest.getText();
            if (text.indexOf(32) == -1) continue;
            return false;
        }
        return true;
    }

    private static class InternalTextTest
    implements TextTest {
        private final short testType;
        private final String text;

        public InternalTextTest(short testType, String text) {
            this.testType = testType;
            this.text = text;
        }

        @Override
        public short getTestType() {
            return this.testType;
        }

        @Override
        public String getText() {
            return this.text;
        }
    }

    private static class TextTestList
    extends AbstractList<TextTest>
    implements RandomAccess {
        private final TextTest[] array;

        private TextTestList(TextTest[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public TextTest get(int index) {
            return this.array[index];
        }
    }
}

