/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.attr;

import java.text.ParseException;

public class CheckedLocalKey
implements CharSequence {
    private final String s;

    private CheckedLocalKey(String s) {
        this.s = s;
    }

    @Override
    public int length() {
        return this.s.length();
    }

    @Override
    public char charAt(int index) {
        return this.s.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.s.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.s;
    }

    public static CheckedLocalKey parse(CharSequence charSequence) throws ParseException {
        int length = charSequence.length();
        if (length == 0) {
            throw new ParseException("Empty charSequence", 0);
        }
        if (!CheckedLocalKey.testFirstChar(charSequence.charAt(0))) {
            throw new ParseException("Wrong first char (" + charSequence.charAt(0) + ")", 0);
        }
        for (int i = 1; i < length; ++i) {
            char carac = charSequence.charAt(i);
            if (CheckedLocalKey.testChar(carac)) continue;
            throw new ParseException("Wrong char (" + carac + ")", i);
        }
        return new CheckedLocalKey(charSequence.toString());
    }

    public static CheckedLocalKey build(CharSequence charSequence) {
        try {
            return CheckedLocalKey.parse(charSequence);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
    }

    private static boolean testFirstChar(char carac) {
        if (carac == '_') {
            return true;
        }
        if (carac >= 'a' && carac <= 'z') {
            return true;
        }
        return carac >= 'A' && carac <= 'Z';
    }

    private static boolean testChar(char carac) {
        if (carac == '_') {
            return true;
        }
        if (carac >= 'a' && carac <= 'z') {
            return true;
        }
        if (carac >= 'A' && carac <= 'Z') {
            return true;
        }
        if (carac >= '0' && carac <= '9') {
            return true;
        }
        switch (carac) {
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case '_': {
                return true;
            }
        }
        return false;
    }
}

