/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.attr;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.text.StringUtils;

public interface Attribute
extends List<String>,
RandomAccess {
    public AttributeKey getAttributeKey();

    default public String getFirstValue() {
        return (String)this.get(0);
    }

    default public boolean isTrue() {
        return StringUtils.isTrue(this.getFirstValue());
    }

    default public String getSubParamValue(String subParamName) {
        String prefix = subParamName + ":";
        for (String value : this) {
            if (!value.startsWith(prefix)) continue;
            String subValue = value.substring(prefix.length()).trim();
            return subValue;
        }
        return null;
    }

    default public Map<String, String> toSubParamMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        StringBuilder noNameBuf = new StringBuilder();
        for (String value : this) {
            int idx = value.indexOf(58);
            if (idx > 0) {
                String name = value.substring(0, idx);
                String subValue = value.substring(idx + 1).trim();
                map.put(name, subValue);
                continue;
            }
            if (noNameBuf.length() > 0) {
                noNameBuf.append(';');
            }
            noNameBuf.append(value);
        }
        if (noNameBuf.length() > 0) {
            map.put("", noNameBuf.toString());
        }
        return map;
    }
}

